"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDevLocation = void 0;
exports.getServiceLocations = getServiceLocations;

var _axios = _interopRequireDefault(require("axios"));

var _lodash = require("lodash");

var _runtime_types = require("../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const getDevLocation = devUrl => ({
  id: 'localhost',
  label: 'Local Synthetics Service',
  geo: {
    lat: 0,
    lon: 0
  },
  url: devUrl
});

exports.getDevLocation = getDevLocation;

async function getServiceLocations(server) {
  var _server$config$servic, _server$config$servic2;

  let locations = [];

  if (process.env.NODE_ENV !== 'production' && (_server$config$servic = server.config.service) !== null && _server$config$servic !== void 0 && _server$config$servic.devUrl) {
    locations = [getDevLocation(server.config.service.devUrl)];
  }

  if (!((_server$config$servic2 = server.config.service) !== null && _server$config$servic2 !== void 0 && _server$config$servic2.manifestUrl)) {
    return {
      locations
    };
  }

  try {
    const {
      data
    } = await _axios.default.get(server.config.service.manifestUrl);
    Object.entries(data.locations).forEach(([locationId, location]) => {
      locations.push({
        id: locationId,
        label: location.geo.name,
        geo: location.geo.location,
        url: location.url,
        isServiceManaged: true
      });
    });
    const throttling = (0, _lodash.pick)(data.throttling, _runtime_types.BandwidthLimitKey.DOWNLOAD, _runtime_types.BandwidthLimitKey.UPLOAD);
    return {
      throttling,
      locations
    };
  } catch (e) {
    server.logger.error(e);
    return {
      locations: []
    };
  }
}