"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sessionEntryLeadersRoute = void 0;

var _configSchema = require("@kbn/config-schema");

var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const sessionEntryLeadersRoute = router => {
  router.get({
    path: _constants.SESSION_ENTRY_LEADERS_ROUTE,
    validate: {
      query: _configSchema.schema.object({
        id: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const client = context.core.elasticsearch.client.asCurrentUser;
    const {
      id
    } = request.query;
    const result = await client.get({
      index: _constants.PROCESS_EVENTS_INDEX,
      id
    });
    return response.ok({
      body: {
        session_entry_leader: result === null || result === void 0 ? void 0 : result._source
      }
    });
  });
};

exports.sessionEntryLeadersRoute = sessionEntryLeadersRoute;