"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerProcessEventsRoute = exports.doSearch = void 0;

var _configSchema = require("@kbn/config-schema");

var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const registerProcessEventsRoute = router => {
  router.get({
    path: _constants.PROCESS_EVENTS_ROUTE,
    validate: {
      query: _configSchema.schema.object({
        sessionEntityId: _configSchema.schema.string(),
        cursor: _configSchema.schema.maybe(_configSchema.schema.string()),
        forward: _configSchema.schema.maybe(_configSchema.schema.boolean())
      })
    }
  }, async (context, request, response) => {
    const client = context.core.elasticsearch.client.asCurrentUser;
    const {
      sessionEntityId,
      cursor,
      forward = true
    } = request.query;
    const body = await doSearch(client, sessionEntityId, cursor, forward);
    return response.ok({
      body
    });
  });
};

exports.registerProcessEventsRoute = registerProcessEventsRoute;

const doSearch = async (client, sessionEntityId, cursor, forward = true) => {
  var _search$hits$total;

  const search = await client.search({
    index: [_constants.PROCESS_EVENTS_INDEX],
    body: {
      query: {
        match: {
          [_constants.ENTRY_SESSION_ENTITY_ID_PROPERTY]: sessionEntityId
        }
      },
      size: _constants.PROCESS_EVENTS_PER_PAGE,
      sort: [{
        '@timestamp': forward ? 'asc' : 'desc'
      }],
      search_after: cursor ? [cursor] : undefined
    }
  });
  const events = search.hits.hits;

  if (!forward) {
    events.reverse();
  }

  const total = typeof search.hits.total === 'number' ? search.hits.total : (_search$hits$total = search.hits.total) === null || _search$hits$total === void 0 ? void 0 : _search$hits$total.value;
  return {
    total,
    events
  };
};

exports.doSearch = doSearch;