"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectCustomCss = void 0;

var _fs = _interopRequireDefault(require("fs"));

var _util = require("util");

var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));

var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const fsp = {
  readFile: (0, _util.promisify)(_fs.default.readFile)
};

const injectCustomCss = async (browser, logger, layout) => {
  const span = _elasticApmNode.default.startSpan('inject_css', 'correction');

  logger.debug('injecting custom css');
  const filePath = layout.getCssOverridesPath();

  if (!filePath) {
    return;
  }

  const buffer = await fsp.readFile(filePath);

  try {
    await browser.evaluate({
      fn: css => {
        const node = document.createElement('style');
        node.type = 'text/css';
        node.innerHTML = css; // eslint-disable-line no-unsanitized/property

        document.getElementsByTagName('head')[0].appendChild(node);
      },
      args: [buffer.toString()]
    }, {
      context: _constants.CONTEXT_INJECTCSS
    }, logger);
  } catch (err) {
    logger.error(err);
    throw new Error(`An error occurred when trying to update Kibana CSS for reporting. ${err.message}`);
  }

  span === null || span === void 0 ? void 0 : span.end();
};

exports.injectCustomCss = injectCustomCss;