"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMockScreenshottingStart = createMockScreenshottingStart;

var _operators = require("rxjs/operators");

var _mocks = require("../../../../src/core/server/mocks");

var _mock = require("./browsers/mock");

var _mock2 = require("./screenshots/mock");

var _formats = require("./formats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


function createMockScreenshottingStart() {
  const driver = (0, _mock.createMockBrowserDriverFactory)();
  const {
    getScreenshots
  } = (0, _mock2.createMockScreenshots)();
  const {
    diagnose
  } = driver;
  const packageInfo = {
    branch: 'screenshot-test',
    buildNum: 567891011,
    buildSha: 'screenshot-dfdfed0a',
    dist: false,
    version: '5000.0.0'
  };
  return {
    diagnose,
    getScreenshots: jest.fn(options => getScreenshots(options).pipe((0, _operators.mergeMap)(options.format === 'pdf' ? (0, _formats.toPdf)({
      logger: _mocks.loggingSystemMock.createLogger(),
      packageInfo
    }) : _formats.toPng)))
  };
}