"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resourceTypeAggQuery = exports.getRisksEsQuery = exports.getResourcesTypes = exports.getResourceTypeFromAggs = void 0;

var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const resourceTypeAggQuery = {
  aggs_by_resource_type: {
    terms: {
      field: 'type.keyword'
    },
    aggs: {
      failed_findings: {
        filter: {
          term: {
            'result.evaluation.keyword': 'failed'
          }
        }
      },
      passed_findings: {
        filter: {
          term: {
            'result.evaluation.keyword': 'passed'
          }
        }
      }
    }
  }
};
exports.resourceTypeAggQuery = resourceTypeAggQuery;

const getRisksEsQuery = query => ({
  index: _constants.CSP_KUBEBEAT_INDEX_PATTERN,
  size: 0,
  query,
  aggs: resourceTypeAggQuery
});

exports.getRisksEsQuery = getRisksEsQuery;

const getResourceTypeFromAggs = queryResult => queryResult.map(bucket => ({
  name: bucket.key,
  totalFindings: bucket.doc_count,
  totalFailed: bucket.failed_findings.doc_count || 0,
  totalPassed: bucket.passed_findings.doc_count || 0
}));

exports.getResourceTypeFromAggs = getResourceTypeFromAggs;

const getResourcesTypes = async (esClient, query) => {
  var _resourceTypesQueryRe;

  const resourceTypesQueryResult = await esClient.search(getRisksEsQuery(query), {
    meta: true
  });
  const resourceTypes = (_resourceTypesQueryRe = resourceTypesQueryResult.body.aggregations) === null || _resourceTypesQueryRe === void 0 ? void 0 : _resourceTypesQueryRe.aggs_by_resource_type.buckets;
  if (!Array.isArray(resourceTypes)) throw new Error('missing resources types buckets');
  return getResourceTypeFromAggs(resourceTypes);
};

exports.getResourcesTypes = getResourcesTypes;