"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspPlugin = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _csp_app_services = require("./lib/csp_app_services");

var _routes = require("./routes");

var _csp_rule_template = require("./saved_objects/csp_rule_template");

var _csp_rule_type = require("./saved_objects/csp_rule_type");

var _initialize_rules = require("./saved_objects/initialize_rules");

var _create_transforms_indices = require("./create_indices/create_transforms_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


class CspPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "CspAppService", new _csp_app_services.CspAppService());
    this.logger = initializerContext.logger.get();
  }

  setup(core, plugins) {
    const cspAppContext = {
      logger: this.logger,
      service: this.CspAppService
    };
    core.savedObjects.registerType(_csp_rule_type.cspRuleAssetType);
    core.savedObjects.registerType(_csp_rule_template.cspRuleTemplateAssetType);
    const router = core.http.createRouter(); // Register server side APIs

    (0, _routes.defineRoutes)(router, cspAppContext);
    return {};
  }

  start(core, plugins) {
    this.CspAppService.start({ ...plugins.fleet
    });
    (0, _initialize_rules.initializeCspRules)(core.savedObjects.createInternalRepository());
    (0, _create_transforms_indices.initializeCspTransformsIndices)(core.elasticsearch.client.asInternalUser, this.logger);
    return {};
  }

  stop() {}

}

exports.CspPlugin = CspPlugin;