"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postCommentRoute = void 0;

var _configSchema = require("@kbn/config-schema");

var _constants = require("../../../../common/constants");

var _error = require("../../../common/error");

var _create_cases_route = require("../create_cases_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const postCommentRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.CASE_COMMENTS_URL,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string()
    })
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const casesClient = await context.cases.getCasesClient();
      const caseId = request.params.case_id;
      const comment = request.body;
      return response.ok({
        body: await casesClient.attachments.add({
          caseId,
          comment
        })
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to post comment in route case id: ${request.params.case_id}: ${error}`,
        error
      });
    }
  }
});
exports.postCommentRoute = postCommentRoute;