"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.referenceLineLayerConfigFunction = void 0;

var _i18n = require("@kbn/i18n");

var _constants = require("../constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const referenceLineLayerConfigFunction = {
  name: _constants.REFERENCE_LINE_LAYER,
  aliases: [],
  type: _constants.REFERENCE_LINE_LAYER,
  help: _i18n.i18n.translate('expressionXY.referenceLineLayer.help', {
    defaultMessage: `Configure a reference line in the xy chart`
  }),
  inputTypes: ['null'],
  args: {
    layerId: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.referenceLineLayer.layerId.help', {
        defaultMessage: `Layer ID`
      })
    },
    accessors: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.referenceLineLayer.accessors.help', {
        defaultMessage: 'The columns to display on the y axis.'
      }),
      multi: true
    },
    yConfig: {
      types: [_constants.Y_CONFIG],
      help: _i18n.i18n.translate('expressionXY.referenceLineLayer.yConfig.help', {
        defaultMessage: 'Additional configuration for y axes'
      }),
      multi: true
    },
    columnToLabel: {
      types: ['string'],
      help: _i18n.i18n.translate('expressionXY.referenceLineLayer.columnToLabel.help', {
        defaultMessage: 'JSON key-value pairs of column ID to label'
      })
    }
  },

  fn(input, args) {
    return {
      type: _constants.REFERENCE_LINE_LAYER,
      ...args,
      layerType: _constants.LayerTypes.REFERENCELINE
    };
  }

};
exports.referenceLineLayerConfigFunction = referenceLineLayerConfigFunction;