"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legendConfigFunction = void 0;

var _charts = require("@elastic/charts");

var _i18n = require("@kbn/i18n");

var _constants = require("../constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const legendConfigFunction = {
  name: _constants.LEGEND_CONFIG,
  aliases: [],
  type: _constants.LEGEND_CONFIG,
  help: _i18n.i18n.translate('expressionXY.legendConfig.help', {
    defaultMessage: `Configure the xy chart's legend`
  }),
  inputTypes: ['null'],
  args: {
    isVisible: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.isVisible.help', {
        defaultMessage: 'Specifies whether or not the legend is visible.'
      })
    },
    position: {
      types: ['string'],
      options: [_charts.Position.Top, _charts.Position.Right, _charts.Position.Bottom, _charts.Position.Left],
      help: _i18n.i18n.translate('expressionXY.legendConfig.position.help', {
        defaultMessage: 'Specifies the legend position.'
      })
    },
    showSingleSeries: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.showSingleSeries.help', {
        defaultMessage: 'Specifies whether a legend with just a single entry should be shown'
      })
    },
    isInside: {
      types: ['boolean'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.isInside.help', {
        defaultMessage: 'Specifies whether a legend is inside the chart'
      })
    },
    horizontalAlignment: {
      types: ['string'],
      options: [_charts.HorizontalAlignment.Right, _charts.HorizontalAlignment.Left],
      help: _i18n.i18n.translate('expressionXY.legendConfig.horizontalAlignment.help', {
        defaultMessage: 'Specifies the horizontal alignment of the legend when it is displayed inside chart.'
      })
    },
    verticalAlignment: {
      types: ['string'],
      options: [_charts.VerticalAlignment.Top, _charts.VerticalAlignment.Bottom],
      help: _i18n.i18n.translate('expressionXY.legendConfig.verticalAlignment.help', {
        defaultMessage: 'Specifies the vertical alignment of the legend when it is displayed inside chart.'
      })
    },
    floatingColumns: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.floatingColumns.help', {
        defaultMessage: 'Specifies the number of columns when legend is displayed inside chart.'
      })
    },
    maxLines: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.maxLines.help', {
        defaultMessage: 'Specifies the number of lines per legend item.'
      })
    },
    shouldTruncate: {
      types: ['boolean'],
      default: true,
      help: _i18n.i18n.translate('expressionXY.legendConfig.shouldTruncate.help', {
        defaultMessage: 'Specifies whether the legend items will be truncated or not'
      })
    },
    legendSize: {
      types: ['number'],
      help: _i18n.i18n.translate('expressionXY.legendConfig.legendSize.help', {
        defaultMessage: 'Specifies the legend size in pixels.'
      })
    }
  },

  fn(input, args) {
    return {
      type: _constants.LEGEND_CONFIG,
      ...args
    };
  }

};
exports.legendConfigFunction = legendConfigFunction;