"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.annotationLayerConfigFunction = annotationLayerConfigFunction;

var _constants = require("../constants");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function annotationLayerConfigFunction() {
  return {
    name: _constants.ANNOTATION_LAYER,
    aliases: [],
    type: _constants.ANNOTATION_LAYER,
    inputTypes: ['null'],
    help: 'Annotation layer in lens',
    args: {
      layerId: {
        types: ['string'],
        help: ''
      },
      hide: {
        types: ['boolean'],
        default: false,
        help: 'Show details'
      },
      annotations: {
        types: ['manual_event_annotation'],
        help: '',
        multi: true
      }
    },
    fn: (input, args) => {
      return {
        type: _constants.ANNOTATION_LAYER,
        ...args,
        layerType: _constants.LayerTypes.ANNOTATIONS
      };
    }
  };
}