"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromRoot = exports.UPSTREAM_BRANCH = exports.REPO_ROOT = void 0;

var _path = _interopRequireDefault(require("path"));

var _loadJsonFile = _interopRequireDefault(require("load-json-file"));

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const readKibanaPkgJson = dir => {
  try {
    const path = _path.default.resolve(dir, 'package.json');

    const json = _loadJsonFile.default.sync(path);

    if (json && typeof json === 'object' && 'name' in json && json.name === 'kibana') {
      return json;
    }
  } catch (error) {
    if (error && error.code === 'ENOENT') {
      return;
    }

    throw error;
  }
};

const findKibanaPackageJson = () => {
  // search for the kibana directory, since this file is moved around it might
  // not be where we think but should always be a relatively close parent
  // of this directory
  const startDir = __dirname;

  const {
    root: rootDir
  } = _path.default.parse(startDir);

  let cursor = startDir;

  while (true) {
    const kibanaPkgJson = readKibanaPkgJson(cursor);

    if (kibanaPkgJson) {
      return {
        kibanaDir: cursor,
        kibanaPkgJson: kibanaPkgJson
      };
    }

    const parent = _path.default.dirname(cursor);

    if (parent === rootDir) {
      throw new Error(`unable to find kibana directory from ${startDir}`);
    }

    cursor = parent;
  }
};

const {
  kibanaDir,
  kibanaPkgJson
} = findKibanaPackageJson();
const REPO_ROOT = kibanaDir;
exports.REPO_ROOT = REPO_ROOT;
const UPSTREAM_BRANCH = kibanaPkgJson.branch;
exports.UPSTREAM_BRANCH = UPSTREAM_BRANCH;

const fromRoot = (...paths) => _path.default.resolve(REPO_ROOT, ...paths);

exports.fromRoot = fromRoot;