"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseScheduleDates = void 0;

var _moment = _interopRequireDefault(require("moment"));

var _datemath = _interopRequireDefault(require("@kbn/datemath"));

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const parseScheduleDates = time => {
  const isValidDateString = !isNaN(Date.parse(time));
  const isValidInput = isValidDateString || time.trim().startsWith('now');
  const formattedDate = isValidDateString ? (0, _moment.default)(time) : isValidInput ? _datemath.default.parse(time) : null;
  return formattedDate != null ? formattedDate : null;
};

exports.parseScheduleDates = parseScheduleDates;