/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import * as t from 'io-ts';
import { PositiveIntegerGreaterThanZero } from '@kbn/securitysolution-io-ts-types';
/**
 * Types the DefaultPerPage as:
 *   - If a string this will convert the string to a number
 *   - If null or undefined, then a default of 20 will be used
 *   - If the number is 0 or less this will not validate as it has to be a positive number greater than zero
 */

export var DefaultPerPage = new t.Type('DefaultPerPage', t.number.is, function (input, context) {
  if (input == null) {
    return t.success(20);
  } else if (typeof input === 'string') {
    return PositiveIntegerGreaterThanZero.validate(parseInt(input, 10), context);
  } else {
    return PositiveIntegerGreaterThanZero.validate(input, context);
  }
}, t.identity);