"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocLinks = void 0;

var _std = require("@kbn/std");

var _get_doc_meta = require("./get_doc_meta");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const getDocLinks = ({
  kibanaBranch
}) => {
  const meta = (0, _get_doc_meta.getDocLinksMeta)({
    kibanaBranch
  });
  const DOC_LINK_VERSION = meta.version;
  const ELASTIC_WEBSITE_URL = meta.elasticWebsiteUrl;
  const ELASTICSEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/reference/${DOC_LINK_VERSION}/`;
  const KIBANA_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/kibana/${DOC_LINK_VERSION}/`;
  const FLEET_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/fleet/${DOC_LINK_VERSION}/`;
  const PLUGIN_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/plugins/${DOC_LINK_VERSION}/`;
  const APM_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/apm/`;
  const SECURITY_SOLUTION_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/security/${DOC_LINK_VERSION}/`;
  const STACK_GETTING_STARTED = `${ELASTIC_WEBSITE_URL}guide/en/elastic-stack-get-started/${DOC_LINK_VERSION}/`;
  const APP_SEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/app-search/${DOC_LINK_VERSION}/`;
  const ENTERPRISE_SEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/enterprise-search/${DOC_LINK_VERSION}/`;
  const WORKPLACE_SEARCH_DOCS = `${ELASTIC_WEBSITE_URL}guide/en/workplace-search/${DOC_LINK_VERSION}/`;
  return (0, _std.deepFreeze)({
    settings: `${ELASTIC_WEBSITE_URL}guide/en/kibana/${DOC_LINK_VERSION}/settings.html`,
    elasticStackGetStarted: `${STACK_GETTING_STARTED}get-started-elastic-stack.html`,
    upgrade: {
      upgradingStackOnPrem: `${ELASTIC_WEBSITE_URL}guide/en/elastic-stack/8.0/upgrading-elastic-stack-on-prem.html`,
      upgradingStackOnCloud: `${ELASTIC_WEBSITE_URL}guide/en/elastic-stack/8.0/upgrade-elastic-stack-for-elastic-cloud.html`
    },
    apm: {
      kibanaSettings: `${KIBANA_DOCS}apm-settings-in-kibana.html`,
      supportedServiceMaps: `${KIBANA_DOCS}service-maps.html#service-maps-supported`,
      customLinks: `${KIBANA_DOCS}custom-links.html`,
      droppedTransactionSpans: `${APM_DOCS}guide/${DOC_LINK_VERSION}/data-model-spans.html#data-model-dropped-spans`,
      upgrading: `${APM_DOCS}guide/${DOC_LINK_VERSION}/upgrade.html`,
      metaData: `${APM_DOCS}guide/${DOC_LINK_VERSION}/data-model-metadata.html`,
      overview: `${APM_DOCS}guide/${DOC_LINK_VERSION}/apm-overview.html`,
      tailSamplingPolicies: `${APM_DOCS}guide/${DOC_LINK_VERSION}/configure-tail-based-sampling.html`,
      elasticAgent: `${APM_DOCS}guide/${DOC_LINK_VERSION}/upgrade-to-apm-integration.html`
    },
    canvas: {
      guide: `${KIBANA_DOCS}canvas.html`
    },
    cloud: {
      indexManagement: `${ELASTIC_WEBSITE_URL}/guide/en/cloud/current/ec-configure-index-management.html`
    },
    console: {
      guide: `${KIBANA_DOCS}console-kibana.html`
    },
    dashboard: {
      guide: `${KIBANA_DOCS}dashboard.html`,
      drilldowns: `${KIBANA_DOCS}drilldowns.html`,
      drilldownsTriggerPicker: `${KIBANA_DOCS}drilldowns.html#url-drilldowns`,
      urlDrilldownTemplateSyntax: `${KIBANA_DOCS}url_templating-language.html`,
      urlDrilldownVariables: `${KIBANA_DOCS}url_templating-language.html#url-template-variables`
    },
    discover: {
      guide: `${KIBANA_DOCS}discover.html`,
      fieldStatistics: `${KIBANA_DOCS}show-field-statistics.html`,
      documentExplorer: `${KIBANA_DOCS}document-explorer.html`
    },
    filebeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}`,
      installation: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-installation-configuration.html`,
      configuration: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/configuring-howto-filebeat.html`,
      elasticsearchModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-module-elasticsearch.html`,
      elasticsearchOutput: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/elasticsearch-output.html`,
      startup: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-starting.html`,
      exportedFields: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/exported-fields.html`,
      suricataModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-module-suricata.html`,
      zeekModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/filebeat/${DOC_LINK_VERSION}/filebeat-module-zeek.html`
    },
    auditbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/auditbeat/${DOC_LINK_VERSION}`,
      auditdModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/auditbeat/${DOC_LINK_VERSION}/auditbeat-module-auditd.html`,
      systemModule: `${ELASTIC_WEBSITE_URL}guide/en/beats/auditbeat/${DOC_LINK_VERSION}/auditbeat-module-system.html`
    },
    appSearch: {
      apiRef: `${APP_SEARCH_DOCS}api-reference.html`,
      apiClients: `${APP_SEARCH_DOCS}api-clients.html`,
      apiKeys: `${APP_SEARCH_DOCS}authentication.html#authentication-api-keys`,
      authentication: `${APP_SEARCH_DOCS}authentication.html`,
      crawlRules: `${APP_SEARCH_DOCS}crawl-web-content.html#crawl-web-content-manage-crawl-rules`,
      curations: `${APP_SEARCH_DOCS}curations-guide.html`,
      duplicateDocuments: `${APP_SEARCH_DOCS}web-crawler-reference.html#web-crawler-reference-content-deduplication`,
      elasticsearchIndexedEngines: `${APP_SEARCH_DOCS}elasticsearch-engines.html`,
      entryPoints: `${APP_SEARCH_DOCS}crawl-web-content.html#crawl-web-content-manage-entry-points`,
      guide: `${APP_SEARCH_DOCS}index.html`,
      indexingDocuments: `${APP_SEARCH_DOCS}indexing-documents-guide.html`,
      indexingDocumentsSchema: `${APP_SEARCH_DOCS}indexing-documents-guide.html#indexing-documents-guide-schema`,
      logSettings: `${APP_SEARCH_DOCS}logs.html`,
      metaEngines: `${APP_SEARCH_DOCS}meta-engines-guide.html`,
      precisionTuning: `${APP_SEARCH_DOCS}precision-tuning.html`,
      relevanceTuning: `${APP_SEARCH_DOCS}relevance-tuning-guide.html`,
      resultSettings: `${APP_SEARCH_DOCS}result-settings-guide.html`,
      searchUI: `${APP_SEARCH_DOCS}reference-ui-guide.html`,
      security: `${APP_SEARCH_DOCS}security-and-users.html`,
      synonyms: `${APP_SEARCH_DOCS}synonyms-guide.html`,
      webCrawler: `${APP_SEARCH_DOCS}web-crawler.html`,
      webCrawlerEventLogs: `${APP_SEARCH_DOCS}view-web-crawler-events-logs.html`
    },
    enterpriseSearch: {
      configuration: `${ENTERPRISE_SEARCH_DOCS}configuration.html`,
      licenseManagement: `${ENTERPRISE_SEARCH_DOCS}license-management.html`,
      mailService: `${ENTERPRISE_SEARCH_DOCS}mailer-configuration.html`,
      troubleshootSetup: `${ENTERPRISE_SEARCH_DOCS}troubleshoot-setup.html`,
      usersAccess: `${ENTERPRISE_SEARCH_DOCS}users-access.html`
    },
    workplaceSearch: {
      apiKeys: `${WORKPLACE_SEARCH_DOCS}workplace-search-api-authentication.html`,
      box: `${WORKPLACE_SEARCH_DOCS}workplace-search-box-connector.html`,
      confluenceCloud: `${WORKPLACE_SEARCH_DOCS}workplace-search-confluence-cloud-connector.html`,
      confluenceServer: `${WORKPLACE_SEARCH_DOCS}workplace-search-confluence-server-connector.html`,
      customSources: `${WORKPLACE_SEARCH_DOCS}workplace-search-custom-api-sources.html`,
      customSourcePermissions: `${WORKPLACE_SEARCH_DOCS}workplace-search-custom-api-sources.html#custom-api-source-document-level-access-control`,
      documentPermissions: `${WORKPLACE_SEARCH_DOCS}workplace-search-sources-document-permissions.html`,
      dropbox: `${WORKPLACE_SEARCH_DOCS}workplace-search-dropbox-connector.html`,
      externalSharePointOnline: `${WORKPLACE_SEARCH_DOCS}sharepoint-online-external.html`,
      externalIdentities: `${WORKPLACE_SEARCH_DOCS}workplace-search-external-identities-api.html`,
      gettingStarted: `${WORKPLACE_SEARCH_DOCS}workplace-search-getting-started.html`,
      gitHub: `${WORKPLACE_SEARCH_DOCS}workplace-search-github-connector.html`,
      gmail: `${WORKPLACE_SEARCH_DOCS}workplace-search-gmail-connector.html`,
      googleDrive: `${WORKPLACE_SEARCH_DOCS}workplace-search-google-drive-connector.html`,
      indexingSchedule: `${WORKPLACE_SEARCH_DOCS}workplace-search-customizing-indexing-rules.html#_indexing_schedule`,
      jiraCloud: `${WORKPLACE_SEARCH_DOCS}workplace-search-jira-cloud-connector.html`,
      jiraServer: `${WORKPLACE_SEARCH_DOCS}workplace-search-jira-server-connector.html`,
      oneDrive: `${WORKPLACE_SEARCH_DOCS}workplace-search-onedrive-connector.html`,
      permissions: `${WORKPLACE_SEARCH_DOCS}workplace-search-permissions.html#organizational-sources-private-sources`,
      salesforce: `${WORKPLACE_SEARCH_DOCS}workplace-search-salesforce-connector.html`,
      security: `${WORKPLACE_SEARCH_DOCS}workplace-search-security.html`,
      serviceNow: `${WORKPLACE_SEARCH_DOCS}workplace-search-servicenow-connector.html`,
      sharePoint: `${WORKPLACE_SEARCH_DOCS}workplace-search-sharepoint-online-connector.html`,
      sharePointServer: `${WORKPLACE_SEARCH_DOCS}sharepoint-server.html`,
      slack: `${WORKPLACE_SEARCH_DOCS}workplace-search-slack-connector.html`,
      synch: `${WORKPLACE_SEARCH_DOCS}workplace-search-customizing-indexing-rules.html`,
      zendesk: `${WORKPLACE_SEARCH_DOCS}workplace-search-zendesk-connector.html`
    },
    metricbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}`,
      configure: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}/configuring-howto-metricbeat.html`,
      httpEndpoint: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}/http-endpoint.html`,
      install: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}/metricbeat-installation-configuration.html`,
      start: `${ELASTIC_WEBSITE_URL}guide/en/beats/metricbeat/${DOC_LINK_VERSION}/metricbeat-starting.html`
    },
    heartbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/heartbeat/${DOC_LINK_VERSION}`
    },
    libbeat: {
      getStarted: `${ELASTIC_WEBSITE_URL}guide/en/beats/libbeat/${DOC_LINK_VERSION}/getting-started.html`
    },
    logstash: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/logstash/${DOC_LINK_VERSION}`,
      inputElasticAgent: `${ELASTIC_WEBSITE_URL}guide/en/logstash/${DOC_LINK_VERSION}/plugins-inputs-elastic_agent.html`
    },
    functionbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/functionbeat/${DOC_LINK_VERSION}`
    },
    winlogbeat: {
      base: `${ELASTIC_WEBSITE_URL}guide/en/beats/winlogbeat/${DOC_LINK_VERSION}`
    },
    aggs: {
      composite: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-composite-aggregation.html`,
      composite_missing_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-composite-aggregation.html#_missing_bucket`,
      date_histogram: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-datehistogram-aggregation.html`,
      date_range: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-daterange-aggregation.html`,
      date_format_pattern: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-daterange-aggregation.html#date-format-pattern`,
      filter: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-filter-aggregation.html`,
      filters: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-filters-aggregation.html`,
      geohash_grid: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-geohashgrid-aggregation.html`,
      histogram: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-histogram-aggregation.html`,
      ip_range: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-iprange-aggregation.html`,
      range: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-range-aggregation.html`,
      significant_terms: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-significantterms-aggregation.html`,
      terms: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-terms-aggregation.html`,
      terms_doc_count_error: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-terms-aggregation.html#_per_bucket_document_count_error`,
      rare_terms: `${ELASTICSEARCH_DOCS}search-aggregations-bucket-rare-terms-aggregation.html`,
      avg: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-avg-aggregation.html`,
      avg_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-avg-bucket-aggregation.html`,
      max_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-max-bucket-aggregation.html`,
      min_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-min-bucket-aggregation.html`,
      sum_bucket: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-sum-bucket-aggregation.html`,
      cardinality: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-cardinality-aggregation.html`,
      count: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-valuecount-aggregation.html`,
      cumulative_sum: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-sum-aggregation.html`,
      derivative: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-derivative-aggregation.html`,
      geo_bounds: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-geobounds-aggregation.html`,
      geo_centroid: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-geocentroid-aggregation.html`,
      max: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-max-aggregation.html`,
      median: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-percentile-aggregation.html`,
      min: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-min-aggregation.html`,
      moving_avg: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-movfn-aggregation.html`,
      percentile_ranks: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-percentile-rank-aggregation.html`,
      serial_diff: `${ELASTICSEARCH_DOCS}search-aggregations-pipeline-serialdiff-aggregation.html`,
      std_dev: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-extendedstats-aggregation.html`,
      sum: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-sum-aggregation.html`,
      top_hits: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-top-hits-aggregation.html`,
      top_metrics: `${ELASTICSEARCH_DOCS}search-aggregations-metrics-top-metrics.html`
    },
    runtimeFields: {
      overview: `${ELASTICSEARCH_DOCS}runtime.html`,
      mapping: `${ELASTICSEARCH_DOCS}runtime-mapping-fields.html`
    },
    scriptedFields: {
      scriptFields: `${ELASTICSEARCH_DOCS}search-request-script-fields.html`,
      scriptAggs: `${ELASTICSEARCH_DOCS}search-aggregations.html`,
      painless: `${ELASTICSEARCH_DOCS}modules-scripting-painless.html`,
      painlessApi: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-api-reference.html`,
      painlessLangSpec: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-lang-spec.html`,
      painlessSyntax: `${ELASTICSEARCH_DOCS}modules-scripting-painless-syntax.html`,
      painlessWalkthrough: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-walkthrough.html`,
      painlessLanguage: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-lang-spec.html`,
      luceneExpressions: `${ELASTICSEARCH_DOCS}modules-scripting-expression.html`
    },
    indexPatterns: {
      introduction: `${KIBANA_DOCS}data-views.html`,
      fieldFormattersNumber: `${KIBANA_DOCS}numeral.html`,
      fieldFormattersString: `${KIBANA_DOCS}managing-data-views.html#string-field-formatters`,
      runtimeFields: `${KIBANA_DOCS}managing-data-views.html#runtime-fields`
    },
    addData: `${KIBANA_DOCS}connect-to-elasticsearch.html`,
    kibana: {
      guide: `${KIBANA_DOCS}index.html`,
      autocompleteSuggestions: `${KIBANA_DOCS}kibana-concepts-analysts.html#autocomplete-suggestions`,
      secureSavedObject: `${KIBANA_DOCS}xpack-security-secure-saved-objects.html`,
      xpackSecurity: `${KIBANA_DOCS}xpack-security.html`
    },
    upgradeAssistant: {
      overview: `${KIBANA_DOCS}upgrade-assistant.html`,
      batchReindex: `${KIBANA_DOCS}batch-start-resume-reindex.html`,
      remoteReindex: `${ELASTICSEARCH_DOCS}docs-reindex.html#reindex-from-remote`
    },
    rollupJobs: `${KIBANA_DOCS}data-rollups.html`,
    elasticsearch: {
      docsBase: `${ELASTICSEARCH_DOCS}`,
      asyncSearch: `${ELASTICSEARCH_DOCS}async-search-intro.html`,
      dataStreams: `${ELASTICSEARCH_DOCS}data-streams.html`,
      deprecationLogging: `${ELASTICSEARCH_DOCS}logging.html#deprecation-logging`,
      createIndex: `${ELASTICSEARCH_DOCS}indices-create-index.html`,
      frozenIndices: `${ELASTICSEARCH_DOCS}frozen-indices.html`,
      gettingStarted: `${ELASTICSEARCH_DOCS}getting-started.html`,
      hiddenIndices: `${ELASTICSEARCH_DOCS}multi-index.html#hidden`,
      ilm: `${ELASTICSEARCH_DOCS}index-lifecycle-management.html`,
      ilmForceMerge: `${ELASTICSEARCH_DOCS}ilm-forcemerge.html`,
      ilmFreeze: `${ELASTICSEARCH_DOCS}ilm-freeze.html`,
      ilmPhaseTransitions: `${ELASTICSEARCH_DOCS}ilm-index-lifecycle.html#ilm-phase-transitions`,
      ilmReadOnly: `${ELASTICSEARCH_DOCS}ilm-readonly.html`,
      ilmRollover: `${ELASTICSEARCH_DOCS}ilm-rollover.html`,
      ilmSearchableSnapshot: `${ELASTICSEARCH_DOCS}ilm-searchable-snapshot.html`,
      ilmSetPriority: `${ELASTICSEARCH_DOCS}ilm-set-priority.html`,
      ilmShrink: `${ELASTICSEARCH_DOCS}ilm-shrink.html`,
      ilmWaitForSnapshot: `${ELASTICSEARCH_DOCS}ilm-wait-for-snapshot.html`,
      indexModules: `${ELASTICSEARCH_DOCS}index-modules.html`,
      indexSettings: `${ELASTICSEARCH_DOCS}index-modules.html#index-modules-settings`,
      dynamicIndexSettings: `${ELASTICSEARCH_DOCS}index-modules.html#dynamic-index-settings`,
      indexTemplates: `${ELASTICSEARCH_DOCS}index-templates.html`,
      mapping: `${ELASTICSEARCH_DOCS}mapping.html`,
      mappingAnalyzer: `${ELASTICSEARCH_DOCS}analyzer.html`,
      mappingCoerce: `${ELASTICSEARCH_DOCS}coerce.html`,
      mappingCopyTo: `${ELASTICSEARCH_DOCS}copy-to.html`,
      mappingDocValues: `${ELASTICSEARCH_DOCS}doc-values.html`,
      mappingDynamic: `${ELASTICSEARCH_DOCS}dynamic.html`,
      mappingDynamicFields: `${ELASTICSEARCH_DOCS}dynamic-field-mapping.html`,
      mappingDynamicTemplates: `${ELASTICSEARCH_DOCS}dynamic-templates.html`,
      mappingEagerGlobalOrdinals: `${ELASTICSEARCH_DOCS}eager-global-ordinals.html`,
      mappingEnabled: `${ELASTICSEARCH_DOCS}enabled.html`,
      mappingFieldData: `${ELASTICSEARCH_DOCS}text.html#fielddata-mapping-param`,
      mappingFieldDataEnable: `${ELASTICSEARCH_DOCS}text.html#before-enabling-fielddata`,
      mappingFieldDataFilter: `${ELASTICSEARCH_DOCS}text.html#field-data-filtering`,
      mappingFieldDataTypes: `${ELASTICSEARCH_DOCS}mapping-types.html`,
      mappingFormat: `${ELASTICSEARCH_DOCS}mapping-date-format.html`,
      mappingIgnoreAbove: `${ELASTICSEARCH_DOCS}ignore-above.html`,
      mappingIgnoreMalformed: `${ELASTICSEARCH_DOCS}ignore-malformed.html`,
      mappingIndex: `${ELASTICSEARCH_DOCS}mapping-index.html`,
      mappingIndexOptions: `${ELASTICSEARCH_DOCS}index-options.html`,
      mappingIndexPhrases: `${ELASTICSEARCH_DOCS}index-phrases.html`,
      mappingIndexPrefixes: `${ELASTICSEARCH_DOCS}index-prefixes.html`,
      mappingJoinFieldsPerformance: `${ELASTICSEARCH_DOCS}parent-join.html#_parent_join_and_performance`,
      mappingMeta: `${ELASTICSEARCH_DOCS}mapping-field-meta.html`,
      mappingMetaFields: `${ELASTICSEARCH_DOCS}mapping-meta-field.html`,
      mappingMultifields: `${ELASTICSEARCH_DOCS}multi-fields.html`,
      mappingNormalizer: `${ELASTICSEARCH_DOCS}normalizer.html`,
      mappingNorms: `${ELASTICSEARCH_DOCS}norms.html`,
      mappingNullValue: `${ELASTICSEARCH_DOCS}null-value.html`,
      mappingParameters: `${ELASTICSEARCH_DOCS}mapping-params.html`,
      mappingPositionIncrementGap: `${ELASTICSEARCH_DOCS}position-increment-gap.html`,
      mappingRankFeatureFields: `${ELASTICSEARCH_DOCS}rank-feature.html`,
      mappingRouting: `${ELASTICSEARCH_DOCS}mapping-routing-field.html`,
      mappingSimilarity: `${ELASTICSEARCH_DOCS}similarity.html`,
      mappingSourceFields: `${ELASTICSEARCH_DOCS}mapping-source-field.html`,
      mappingSourceFieldsDisable: `${ELASTICSEARCH_DOCS}mapping-source-field.html#disable-source-field`,
      mappingStore: `${ELASTICSEARCH_DOCS}mapping-store.html`,
      mappingTermVector: `${ELASTICSEARCH_DOCS}term-vector.html`,
      mappingTypesRemoval: `${ELASTICSEARCH_DOCS}removal-of-types.html`,
      migrateIndexAllocationFilters: `${ELASTICSEARCH_DOCS}migrate-index-allocation-filters.html`,
      migrationApiDeprecation: `${ELASTICSEARCH_DOCS}migration-api-deprecation.html`,
      nodeRoles: `${ELASTICSEARCH_DOCS}modules-node.html#node-roles`,
      releaseHighlights: `${ELASTICSEARCH_DOCS}release-highlights.html`,
      version8ReleaseHighlights: `${ELASTIC_WEBSITE_URL}guide/en/elastic-stack/8.0/elastic-stack-highlights.html`,
      remoteClusters: `${ELASTICSEARCH_DOCS}remote-clusters.html`,
      remoteClustersProxy: `${ELASTICSEARCH_DOCS}remote-clusters.html#proxy-mode`,
      remoteClusersProxySettings: `${ELASTICSEARCH_DOCS}remote-clusters-settings.html#remote-cluster-proxy-settings`,
      scriptParameters: `${ELASTICSEARCH_DOCS}modules-scripting-using.html#prefer-params`,
      shardAllocationSettings: `${ELASTICSEARCH_DOCS}modules-cluster.html#cluster-shard-allocation-settings`,
      sortSearch: `${ELASTICSEARCH_DOCS}sort-search-results.html`,
      transportSettings: `${ELASTICSEARCH_DOCS}modules-network.html#common-network-settings`,
      typesRemoval: `${ELASTICSEARCH_DOCS}removal-of-types.html`,
      setupUpgrade: `${ELASTICSEARCH_DOCS}setup-upgrade.html`,
      apiCompatibilityHeader: `${ELASTICSEARCH_DOCS}api-conventions.html#api-compatibility`
    },
    siem: {
      guide: `${SECURITY_SOLUTION_DOCS}index.html`,
      gettingStarted: `${SECURITY_SOLUTION_DOCS}index.html`,
      privileges: `${SECURITY_SOLUTION_DOCS}sec-requirements.html`,
      ml: `${SECURITY_SOLUTION_DOCS}machine-learning.html`,
      ruleChangeLog: `${SECURITY_SOLUTION_DOCS}prebuilt-rules-changelog.html`,
      detectionsReq: `${SECURITY_SOLUTION_DOCS}detections-permissions-section.html`,
      networkMap: `${SECURITY_SOLUTION_DOCS}conf-map-ui.html`,
      troubleshootGaps: `${SECURITY_SOLUTION_DOCS}alerts-ui-monitor.html#troubleshoot-gaps`,
      ruleApiOverview: `${SECURITY_SOLUTION_DOCS}rule-api-overview.html`
    },
    securitySolution: {
      trustedApps: `${ELASTIC_WEBSITE_URL}guide/en/security/${DOC_LINK_VERSION}/trusted-apps-ov.html`,
      eventFilters: `${ELASTIC_WEBSITE_URL}guide/en/security/${DOC_LINK_VERSION}/event-filters.html`,
      blocklist: `${ELASTIC_WEBSITE_URL}guide/en/security/${DOC_LINK_VERSION}/blocklist.html`
    },
    query: {
      eql: `${ELASTICSEARCH_DOCS}eql.html`,
      kueryQuerySyntax: `${KIBANA_DOCS}kuery-query.html`,
      luceneQuery: `${ELASTICSEARCH_DOCS}query-dsl-query-string-query.html`,
      luceneQuerySyntax: `${ELASTICSEARCH_DOCS}query-dsl-query-string-query.html#query-string-syntax`,
      percolate: `${ELASTICSEARCH_DOCS}query-dsl-percolate-query.html`,
      queryDsl: `${ELASTICSEARCH_DOCS}query-dsl.html`
    },
    search: {
      sessions: `${KIBANA_DOCS}search-sessions.html`,
      sessionLimits: `${KIBANA_DOCS}search-sessions.html#_limitations`
    },
    date: {
      dateMath: `${ELASTICSEARCH_DOCS}common-options.html#date-math`,
      dateMathIndexNames: `${ELASTICSEARCH_DOCS}date-math-index-names.html`
    },
    management: {
      dashboardSettings: `${KIBANA_DOCS}advanced-options.html#kibana-dashboard-settings`,
      indexManagement: `${ELASTICSEARCH_DOCS}index-mgmt.html`,
      kibanaSearchSettings: `${KIBANA_DOCS}advanced-options.html#kibana-search-settings`,
      visualizationSettings: `${KIBANA_DOCS}advanced-options.html#kibana-visualization-settings`,
      timelionSettings: `${KIBANA_DOCS}advanced-options.html#kibana-timelion-settings`,
      savedObjectsApiList: `${KIBANA_DOCS}saved-objects-api.html#saved-objects-api`
    },
    ml: {
      guide: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/index.html`,
      aggregations: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-configuring-aggregation.html`,
      anomalyDetection: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-overview.html`,
      anomalyDetectionJobs: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-finding-anomalies.html`,
      anomalyDetectionConfiguringCategories: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-configuring-categories.html`,
      anomalyDetectionBucketSpan: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-bucket-span`,
      anomalyDetectionCardinality: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-cardinality`,
      anomalyDetectionCreateJobs: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-create-job`,
      anomalyDetectionDetectors: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-detectors`,
      anomalyDetectionInfluencers: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-influencers`,
      anomalyDetectionJobResource: `${ELASTICSEARCH_DOCS}ml-put-job.html#ml-put-job-path-parms`,
      anomalyDetectionJobResourceAnalysisConfig: `${ELASTICSEARCH_DOCS}ml-put-job.html#put-analysisconfig`,
      anomalyDetectionJobTips: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-job-tips`,
      alertingRules: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-configuring-alerts.html`,
      anomalyDetectionModelMemoryLimits: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-model-memory-limits`,
      calendars: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-calendars`,
      classificationEvaluation: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-dfa-classification.html#ml-dfanalytics-classification-evaluation`,
      customRules: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-ad-run-jobs.html#ml-ad-rules`,
      customUrls: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-configuring-url.html`,
      dataFrameAnalytics: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-dfanalytics.html`,
      dFAPrepareData: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-dfa-overview.html#prepare-transform-data`,
      featureImportance: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-feature-importance.html`,
      outlierDetectionRoc: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-dfa-finding-outliers.html#ml-dfanalytics-roc`,
      regressionEvaluation: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-dfa-regression.html#ml-dfanalytics-regression-evaluation`,
      classificationAucRoc: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-dfa-classification.html#ml-dfanalytics-class-aucroc`,
      setUpgradeMode: `${ELASTICSEARCH_DOCS}ml-set-upgrade-mode.html`,
      trainedModels: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-trained-models.html`
    },
    transforms: {
      guide: `${ELASTICSEARCH_DOCS}transforms.html`,
      // TODO add valid docs URL
      alertingRules: `${ELASTIC_WEBSITE_URL}guide/en/machine-learning/${DOC_LINK_VERSION}/ml-configuring-alerts.html`
    },
    visualize: {
      guide: `${KIBANA_DOCS}dashboard.html`,
      lens: `${ELASTIC_WEBSITE_URL}what-is/kibana-lens`,
      lensPanels: `${KIBANA_DOCS}lens.html`,
      maps: `${ELASTIC_WEBSITE_URL}maps`,
      vega: `${KIBANA_DOCS}vega.html`,
      tsvbIndexPatternMode: `${KIBANA_DOCS}tsvb.html#tsvb-index-pattern-mode`
    },
    observability: {
      guide: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/index.html`,
      infrastructureThreshold: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/infrastructure-threshold-alert.html`,
      logsThreshold: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/logs-threshold-alert.html`,
      metricsThreshold: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/metrics-threshold-alert.html`,
      monitorStatus: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/monitor-status-alert.html`,
      monitorUptime: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/monitor-uptime.html`,
      tlsCertificate: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/tls-certificate-alert.html`,
      uptimeDurationAnomaly: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/duration-anomaly-alert.html`,
      monitorLogs: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/monitor-logs.html`,
      analyzeMetrics: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/analyze-metrics.html`,
      monitorUptimeSynthetics: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/monitor-uptime-synthetics.html`,
      userExperience: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/user-experience.html`,
      createAlerts: `${ELASTIC_WEBSITE_URL}guide/en/observability/${DOC_LINK_VERSION}/create-alerts.html`
    },
    alerting: {
      guide: `${KIBANA_DOCS}create-and-manage-rules.html`,
      actionTypes: `${KIBANA_DOCS}action-types.html`,
      apmRules: `${KIBANA_DOCS}apm-alerts.html`,
      emailAction: `${KIBANA_DOCS}email-action-type.html`,
      emailActionConfig: `${KIBANA_DOCS}email-action-type.html`,
      emailExchangeClientSecretConfig: `${KIBANA_DOCS}email-action-type.html#exchange-client-secret`,
      emailExchangeClientIdConfig: `${KIBANA_DOCS}email-action-type.html#exchange-client-tenant-id`,
      generalSettings: `${KIBANA_DOCS}alert-action-settings-kb.html#general-alert-action-settings`,
      indexAction: `${KIBANA_DOCS}index-action-type.html`,
      esQuery: `${KIBANA_DOCS}rule-type-es-query.html`,
      indexThreshold: `${KIBANA_DOCS}rule-type-index-threshold.html`,
      pagerDutyAction: `${KIBANA_DOCS}pagerduty-action-type.html`,
      preconfiguredConnectors: `${KIBANA_DOCS}pre-configured-connectors.html`,
      preconfiguredAlertHistoryConnector: `${KIBANA_DOCS}index-action-type.html#preconfigured-connector-alert-history`,
      serviceNowAction: `${KIBANA_DOCS}servicenow-action-type.html#configuring-servicenow`,
      serviceNowSIRAction: `${KIBANA_DOCS}servicenow-sir-action-type.html`,
      setupPrerequisites: `${KIBANA_DOCS}alerting-setup.html#alerting-prerequisites`,
      slackAction: `${KIBANA_DOCS}slack-action-type.html#configuring-slack`,
      teamsAction: `${KIBANA_DOCS}teams-action-type.html#configuring-teams`
    },
    maps: {
      guide: `${KIBANA_DOCS}maps.html`,
      importGeospatialPrivileges: `${KIBANA_DOCS}import-geospatial-data.html#import-geospatial-privileges`,
      gdalTutorial: `${ELASTIC_WEBSITE_URL}blog/how-to-ingest-geospatial-data-into-elasticsearch-with-gdal`
    },
    monitoring: {
      alertsKibana: `${KIBANA_DOCS}kibana-alerts.html`,
      alertsKibanaCpuThreshold: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-cpu-threshold`,
      alertsKibanaDiskThreshold: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-disk-usage-threshold`,
      alertsKibanaJvmThreshold: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-jvm-memory-threshold`,
      alertsKibanaMissingData: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-missing-monitoring-data`,
      alertsKibanaThreadpoolRejections: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-thread-pool-rejections`,
      alertsKibanaCCRReadExceptions: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-ccr-read-exceptions`,
      alertsKibanaLargeShardSize: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-large-shard-size`,
      alertsKibanaClusterAlerts: `${KIBANA_DOCS}kibana-alerts.html#kibana-alerts-cluster-alerts`,
      metricbeatBlog: `${ELASTIC_WEBSITE_URL}blog/external-collection-for-elastic-stack-monitoring-is-now-available-via-metricbeat`,
      monitorElasticsearch: `${ELASTICSEARCH_DOCS}configuring-metricbeat.html`,
      monitorKibana: `${KIBANA_DOCS}monitoring-metricbeat.html`,
      monitorLogstash: `${ELASTIC_WEBSITE_URL}guide/en/logstash/${DOC_LINK_VERSION}/monitoring-with-metricbeat.html`,
      troubleshootKibana: `${KIBANA_DOCS}monitor-troubleshooting.html`
    },
    security: {
      apiKeyServiceSettings: `${ELASTICSEARCH_DOCS}security-settings.html#api-key-service-settings`,
      clusterPrivileges: `${ELASTICSEARCH_DOCS}security-privileges.html#privileges-list-cluster`,
      elasticsearchSettings: `${ELASTICSEARCH_DOCS}security-settings.html`,
      elasticsearchEnableSecurity: `${ELASTICSEARCH_DOCS}configuring-stack-security.html`,
      elasticsearchEnableApiKeys: `${ELASTICSEARCH_DOCS}security-settings.html#api-key-service-settings`,
      indicesPrivileges: `${ELASTICSEARCH_DOCS}security-privileges.html#privileges-list-indices`,
      kibanaTLS: `${ELASTICSEARCH_DOCS}security-basic-setup.html#encrypt-internode-communication`,
      kibanaPrivileges: `${KIBANA_DOCS}kibana-privileges.html`,
      mappingRoles: `${ELASTICSEARCH_DOCS}mapping-roles.html`,
      mappingRolesFieldRules: `${ELASTICSEARCH_DOCS}role-mapping-resources.html#mapping-roles-rule-field`,
      runAsPrivilege: `${ELASTICSEARCH_DOCS}security-privileges.html#_run_as_privilege`
    },
    spaces: {
      kibanaLegacyUrlAliases: `${KIBANA_DOCS}legacy-url-aliases.html`,
      kibanaDisableLegacyUrlAliasesApi: `${KIBANA_DOCS}spaces-api-disable-legacy-url-aliases.html`
    },
    watcher: {
      jiraAction: `${ELASTICSEARCH_DOCS}actions-jira.html`,
      pagerDutyAction: `${ELASTICSEARCH_DOCS}actions-pagerduty.html`,
      slackAction: `${ELASTICSEARCH_DOCS}actions-slack.html`,
      ui: `${KIBANA_DOCS}watcher-ui.html`
    },
    ccs: {
      guide: `${ELASTICSEARCH_DOCS}modules-cross-cluster-search.html`,
      skippingDisconnectedClusters: `${ELASTICSEARCH_DOCS}modules-cross-cluster-search.html#skip-unavailable-clusters`
    },
    apis: {
      bulkIndexAlias: `${ELASTICSEARCH_DOCS}indices-aliases.html`,
      byteSizeUnits: `${ELASTICSEARCH_DOCS}api-conventions.html#byte-units`,
      createAutoFollowPattern: `${ELASTICSEARCH_DOCS}ccr-put-auto-follow-pattern.html`,
      createFollower: `${ELASTICSEARCH_DOCS}ccr-put-follow.html`,
      createIndex: `${ELASTICSEARCH_DOCS}indices-create-index.html`,
      createSnapshotLifecyclePolicy: `${ELASTICSEARCH_DOCS}slm-api-put-policy.html`,
      createRoleMapping: `${ELASTICSEARCH_DOCS}security-api-put-role-mapping.html`,
      createRoleMappingTemplates: `${ELASTICSEARCH_DOCS}security-api-put-role-mapping.html#_role_templates`,
      createRollupJobsRequest: `${ELASTICSEARCH_DOCS}rollup-put-job.html#rollup-put-job-api-request-body`,
      createApiKey: `${ELASTICSEARCH_DOCS}security-api-create-api-key.html`,
      createPipeline: `${ELASTICSEARCH_DOCS}put-pipeline-api.html`,
      createTransformRequest: `${ELASTICSEARCH_DOCS}put-transform.html#put-transform-request-body`,
      cronExpressions: `${ELASTICSEARCH_DOCS}cron-expressions.html`,
      executeWatchActionModes: `${ELASTICSEARCH_DOCS}watcher-api-execute-watch.html#watcher-api-execute-watch-action-mode`,
      indexExists: `${ELASTICSEARCH_DOCS}indices-exists.html`,
      multiSearch: `${ELASTICSEARCH_DOCS}search-multi-search.html`,
      openIndex: `${ELASTICSEARCH_DOCS}indices-open-close.html`,
      putComponentTemplate: `${ELASTICSEARCH_DOCS}indices-component-template.html`,
      painlessExecute: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-execute-api.html`,
      painlessExecuteAPIContexts: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/painless/${DOC_LINK_VERSION}/painless-execute-api.html#_contexts`,
      putComponentTemplateMetadata: `${ELASTICSEARCH_DOCS}indices-component-template.html#component-templates-metadata`,
      putEnrichPolicy: `${ELASTICSEARCH_DOCS}put-enrich-policy-api.html`,
      putIndexTemplateV1: `${ELASTICSEARCH_DOCS}indices-templates-v1.html`,
      putSnapshotLifecyclePolicy: `${ELASTICSEARCH_DOCS}slm-api-put-policy.html`,
      putWatch: `${ELASTICSEARCH_DOCS}watcher-api-put-watch.html`,
      searchPreference: `${ELASTICSEARCH_DOCS}search-search.html#search-preference`,
      simulatePipeline: `${ELASTICSEARCH_DOCS}simulate-pipeline-api.html`,
      timeUnits: `${ELASTICSEARCH_DOCS}api-conventions.html#time-units`,
      unfreezeIndex: `${ELASTICSEARCH_DOCS}unfreeze-index-api.html`,
      updateTransform: `${ELASTICSEARCH_DOCS}update-transform.html`
    },
    plugins: {
      azureRepo: `${ELASTICSEARCH_DOCS}repository-azure.html`,
      gcsRepo: `${ELASTICSEARCH_DOCS}repository-gcs.html`,
      hdfsRepo: `${PLUGIN_DOCS}repository-hdfs.html`,
      s3Repo: `${ELASTICSEARCH_DOCS}repository-s3.html`,
      snapshotRestoreRepos: `${ELASTICSEARCH_DOCS}snapshots-register-repository.html`,
      mapperSize: `${PLUGIN_DOCS}mapper-size-usage.html`
    },
    snapshotRestore: {
      guide: `${ELASTICSEARCH_DOCS}snapshot-restore.html`,
      changeIndexSettings: `${ELASTICSEARCH_DOCS}index-modules.html`,
      createSnapshot: `${ELASTICSEARCH_DOCS}snapshots-take-snapshot.html`,
      getSnapshot: `${ELASTICSEARCH_DOCS}get-snapshot-api.html`,
      registerSharedFileSystem: `${ELASTICSEARCH_DOCS}snapshots-filesystem-repository.html#filesystem-repository-settings`,
      registerSourceOnly: `${ELASTICSEARCH_DOCS}snapshots-source-only-repository.html#source-only-repository-settings`,
      registerUrl: `${ELASTICSEARCH_DOCS}snapshots-read-only-repository.html#read-only-url-repository-settings`,
      restoreSnapshot: `${ELASTICSEARCH_DOCS}snapshots-restore-snapshot.html`,
      restoreSnapshotApi: `${ELASTICSEARCH_DOCS}restore-snapshot-api.html#restore-snapshot-api-request-body`,
      searchableSnapshotSharedCache: `${ELASTICSEARCH_DOCS}searchable-snapshots.html#searchable-snapshots-shared-cache`
    },
    ingest: {
      append: `${ELASTICSEARCH_DOCS}append-processor.html`,
      bytes: `${ELASTICSEARCH_DOCS}bytes-processor.html`,
      circle: `${ELASTICSEARCH_DOCS}ingest-circle-processor.html`,
      convert: `${ELASTICSEARCH_DOCS}convert-processor.html`,
      csv: `${ELASTICSEARCH_DOCS}csv-processor.html`,
      date: `${ELASTICSEARCH_DOCS}date-processor.html`,
      dateIndexName: `${ELASTICSEARCH_DOCS}date-index-name-processor.html`,
      dissect: `${ELASTICSEARCH_DOCS}dissect-processor.html`,
      dissectKeyModifiers: `${ELASTICSEARCH_DOCS}dissect-processor.html#dissect-key-modifiers`,
      dotExpander: `${ELASTICSEARCH_DOCS}dot-expand-processor.html`,
      drop: `${ELASTICSEARCH_DOCS}drop-processor.html`,
      enrich: `${ELASTICSEARCH_DOCS}ingest-enriching-data.html`,
      fail: `${ELASTICSEARCH_DOCS}fail-processor.html`,
      foreach: `${ELASTICSEARCH_DOCS}foreach-processor.html`,
      geoIp: `${ELASTICSEARCH_DOCS}geoip-processor.html`,
      geoMatch: `${ELASTICSEARCH_DOCS}geo-match-enrich-policy-type.html`,
      grok: `${ELASTICSEARCH_DOCS}grok-processor.html`,
      gsub: `${ELASTICSEARCH_DOCS}gsub-processor.html`,
      htmlString: `${ELASTICSEARCH_DOCS}htmlstrip-processor.html`,
      inference: `${ELASTICSEARCH_DOCS}inference-processor.html`,
      inferenceClassification: `${ELASTICSEARCH_DOCS}inference-processor.html#inference-processor-classification-opt`,
      inferenceRegression: `${ELASTICSEARCH_DOCS}inference-processor.html#inference-processor-regression-opt`,
      join: `${ELASTICSEARCH_DOCS}join-processor.html`,
      json: `${ELASTICSEARCH_DOCS}json-processor.html`,
      kv: `${ELASTICSEARCH_DOCS}kv-processor.html`,
      lowercase: `${ELASTICSEARCH_DOCS}lowercase-processor.html`,
      pipeline: `${ELASTICSEARCH_DOCS}pipeline-processor.html`,
      pipelines: `${ELASTICSEARCH_DOCS}ingest.html`,
      csvPipelines: `${ELASTIC_WEBSITE_URL}guide/en/ecs/${DOC_LINK_VERSION}/ecs-converting.html`,
      pipelineFailure: `${ELASTICSEARCH_DOCS}ingest.html#handling-pipeline-failures`,
      processors: `${ELASTICSEARCH_DOCS}processors.html`,
      remove: `${ELASTICSEARCH_DOCS}remove-processor.html`,
      rename: `${ELASTICSEARCH_DOCS}rename-processor.html`,
      script: `${ELASTICSEARCH_DOCS}script-processor.html`,
      set: `${ELASTICSEARCH_DOCS}set-processor.html`,
      setSecurityUser: `${ELASTICSEARCH_DOCS}ingest-node-set-security-user-processor.html`,
      sort: `${ELASTICSEARCH_DOCS}sort-processor.html`,
      split: `${ELASTICSEARCH_DOCS}split-processor.html`,
      trim: `${ELASTICSEARCH_DOCS}trim-processor.html`,
      uppercase: `${ELASTICSEARCH_DOCS}uppercase-processor.html`,
      uriParts: `${ELASTICSEARCH_DOCS}uri-parts-processor.html`,
      urlDecode: `${ELASTICSEARCH_DOCS}urldecode-processor.html`,
      userAgent: `${ELASTICSEARCH_DOCS}user-agent-processor.html`
    },
    fleet: {
      guide: `${FLEET_DOCS}index.html`,
      fleetServer: `${FLEET_DOCS}fleet-server.html`,
      fleetServerAddFleetServer: `${FLEET_DOCS}add-a-fleet-server.html`,
      settings: `${FLEET_DOCS}fleet-settings.html`,
      settingsFleetServerHostSettings: `${FLEET_DOCS}fleet-settings.html#fleet-server-hosts-setting`,
      settingsFleetServerProxySettings: `${KIBANA_DOCS}fleet-settings-kb.html#fleet-data-visualizer-settings`,
      troubleshooting: `${FLEET_DOCS}fleet-troubleshooting.html`,
      elasticAgent: `${FLEET_DOCS}elastic-agent-installation.html`,
      beatsAgentComparison: `${FLEET_DOCS}beats-agent-comparison.html`,
      datastreams: `${FLEET_DOCS}data-streams.html`,
      datastreamsILM: `${FLEET_DOCS}data-streams.html#data-streams-ilm`,
      datastreamsNamingScheme: `${FLEET_DOCS}data-streams.html#data-streams-naming-scheme`,
      installElasticAgent: `${FLEET_DOCS}install-fleet-managed-elastic-agent.html`,
      installElasticAgentStandalone: `${FLEET_DOCS}install-standalone-elastic-agent.html`,
      upgradeElasticAgent: `${FLEET_DOCS}upgrade-elastic-agent.html`,
      learnMoreBlog: `${ELASTIC_WEBSITE_URL}blog/elastic-agent-and-fleet-make-it-easier-to-integrate-your-systems-with-elastic`,
      apiKeysLearnMore: `${KIBANA_DOCS}api-keys.html`,
      onPremRegistry: `${FLEET_DOCS}air-gapped.html`,
      secureLogstash: `${FLEET_DOCS}secure-logstash-connections.html`
    },
    ecs: {
      guide: `${ELASTIC_WEBSITE_URL}guide/en/ecs/current/index.html`
    },
    clients: {
      /** Changes to these URLs must also be synched in src/plugins/custom_integrations/server/language_clients/index.ts */
      guide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/index.html`,
      goIndex: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/go-api/${DOC_LINK_VERSION}/index.html`,
      goOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/go-api/${DOC_LINK_VERSION}/overview.html`,
      javaBasicAuthentication: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/_basic_authentication.html`,
      javaIndex: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/index.html`,
      javaInstallation: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/installation.html`,
      javaIntroduction: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/introduction.html`,
      javaRestLow: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/java-api-client/${DOC_LINK_VERSION}/java-rest-low.html`,
      jsClientConnecting: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/javascript-api/${DOC_LINK_VERSION}/client-connecting.html`,
      jsIntro: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/javascript-api/${DOC_LINK_VERSION}/introduction.html`,
      netGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/${DOC_LINK_VERSION}/index.html`,
      netIntroduction: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/${DOC_LINK_VERSION}/introduction.html`,
      netNest: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/${DOC_LINK_VERSION}/nest.html`,
      netSingleNode: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/net-api/${DOC_LINK_VERSION}/connecting.html#single-node`,
      perlGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/perl-api/${DOC_LINK_VERSION}/index.html`,
      phpConnecting: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/connecting.html`,
      phpInstallation: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/installation.html`,
      phpGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/index.html`,
      phpOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/php-api/${DOC_LINK_VERSION}/overview.html`,
      pythonAuthentication: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/python-api/${DOC_LINK_VERSION}/connecting.html#authentication`,
      pythonGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/python-api/${DOC_LINK_VERSION}/index.html`,
      pythonOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/python-api/${DOC_LINK_VERSION}/overview.html`,
      rubyAuthentication: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/ruby-api/${DOC_LINK_VERSION}/connecting.html#client-auth`,
      rubyOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/ruby-api/${DOC_LINK_VERSION}/ruby_client.html`,
      rustGuide: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/rust-api/${DOC_LINK_VERSION}/index.html`,
      rustOverview: `${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/client/rust-api/${DOC_LINK_VERSION}/overview.html`
    },
    endpoints: {
      troubleshooting: `${ELASTIC_WEBSITE_URL}guide/en/security/${DOC_LINK_VERSION}/ts-management.html#ts-endpoints`
    },
    legal: {
      privacyStatement: `${ELASTIC_WEBSITE_URL}legal/privacy-statement`
    }
  });
};

exports.getDocLinks = getDocLinks;