"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiToolTipPopover = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react2 = require("@emotion/react");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

var EuiToolTipPopover = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(EuiToolTipPopover, _Component);

  var _super = _createSuper(EuiToolTipPopover);

  function EuiToolTipPopover() {
    var _this;

    (0, _classCallCheck2.default)(this, EuiToolTipPopover);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "popover", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateDimensions", function () {
      requestAnimationFrame(function () {
        // Because of this delay, sometimes `positionToolTip` becomes unavailable.
        if (_this.popover) {
          _this.props.positionToolTip();
        }
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setPopoverRef", function (ref) {
      _this.popover = ref;

      if (_this.props.popoverRef) {
        _this.props.popoverRef(ref);
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiToolTipPopover, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.body.classList.add('euiBody-hasPortalContent');
      window.addEventListener('resize', this.updateDimensions);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.body.classList.remove('euiBody-hasPortalContent');
      window.removeEventListener('resize', this.updateDimensions);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          title = _this$props.title,
          className = _this$props.className,
          positionToolTip = _this$props.positionToolTip,
          popoverRef = _this$props.popoverRef,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "title", "className", "positionToolTip", "popoverRef"]);
      var classes = (0, _classnames.default)('euiToolTipPopover', className);
      var optionalTitle;

      if (title) {
        optionalTitle = (0, _react2.jsx)("div", {
          className: "euiToolTip__title"
        }, title);
      }

      return (0, _react2.jsx)("div", (0, _extends2.default)({
        className: classes,
        ref: this.setPopoverRef
      }, rest), optionalTitle, children);
    }
  }]);
  return EuiToolTipPopover;
}(_react.Component);

exports.EuiToolTipPopover = EuiToolTipPopover;
EuiToolTipPopover.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  positionToolTip: _propTypes.default.func.isRequired,
  children: _propTypes.default.node,
  title: _propTypes.default.node,
  popoverRef: _propTypes.default.func
};