"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiScreenReaderLive = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _screen_reader_only = require("../screen_reader_only");

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiScreenReaderLive = function EuiScreenReaderLive(_ref) {
  var children = _ref.children,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? true : _ref$isActive,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'status' : _ref$role,
      _ref$ariaLive = _ref['aria-live'],
      ariaLive = _ref$ariaLive === void 0 ? 'polite' : _ref$ariaLive;

  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      toggle = _useState2[0],
      setToggle = _useState2[1];

  (0, _react.useEffect)(function () {
    setToggle(function (toggle) {
      return !toggle;
    });
  }, [children]);
  return (
    /**
     * Intentionally uses two persistent live regions with oscillating content updates.
     * This resolves the problem of duplicate screen reader announcements in rapid succession
     * caused by React's virtual DOM behaviour (https://github.com/nvaccess/nvda/issues/7996#issuecomment-413641709)
     *
     * Adapted from https://github.com/alphagov/accessible-autocomplete/blob/a7106f03150941fc15e6c1ceb0a90e8872fa86ef/src/status.js
     * Debouncing was not needed for this case, but could prove to be useful for future use cases.
     * See also https://github.com/AlmeroSteyn/react-aria-live and https://github.com/dequelabs/ngA11y
     * for more examples of the double region approach.
     */
    (0, _react2.jsx)(_screen_reader_only.EuiScreenReaderOnly, null, (0, _react2.jsx)("div", null, (0, _react2.jsx)("div", {
      role: role,
      "aria-atomic": "true",
      "aria-live": ariaLive
    }, isActive && toggle ? children : ''), (0, _react2.jsx)("div", {
      role: role,
      "aria-atomic": "true",
      "aria-live": ariaLive
    }, isActive && !toggle ? children : '')))
  );
};

exports.EuiScreenReaderLive = EuiScreenReaderLive;
EuiScreenReaderLive.propTypes = {
  /**
     * Whether to make screen readers aware of the content
     */
  isActive: _propTypes.default.bool,

  /**
     * Content for screen readers to announce
     */
  children: _propTypes.default.node,

  /**
     * `role` attribute for both live regions.
     *
     * https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions#roles_with_implicit_live_region_attributes
     */
  role: _propTypes.default.any,

  /**
     * `aria-live` attribute for both live regions
     */
  "aria-live": _propTypes.default.any
};