"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMark = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _mark = require("./mark.styles");

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var EuiMark = function EuiMark(_ref) {
  var children = _ref.children,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className"]);
  var useTheme = (0, _services.useEuiTheme)();
  var styles = (0, _mark.euiMarkStyles)(useTheme);
  var classes = (0, _classnames.default)('euiMark', className);
  return (0, _react2.jsx)("mark", (0, _extends2.default)({
    css: [styles, ";label:EuiMark;" + (process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL21hcmsvbWFyay50c3giXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBK0JVIiwiZmlsZSI6Ii4uLy4uLy4uLy4uL3NyYy9jb21wb25lbnRzL21hcmsvbWFyay50c3giLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IEVsYXN0aWNzZWFyY2ggQi5WLiBhbmQvb3IgbGljZW5zZWQgdG8gRWxhc3RpY3NlYXJjaCBCLlYuIHVuZGVyIG9uZVxuICogb3IgbW9yZSBjb250cmlidXRvciBsaWNlbnNlIGFncmVlbWVudHMuIExpY2Vuc2VkIHVuZGVyIHRoZSBFbGFzdGljIExpY2Vuc2VcbiAqIDIuMCBhbmQgdGhlIFNlcnZlciBTaWRlIFB1YmxpYyBMaWNlbnNlLCB2IDE7IHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0XG4gKiBpbiBjb21wbGlhbmNlIHdpdGgsIGF0IHlvdXIgZWxlY3Rpb24sIHRoZSBFbGFzdGljIExpY2Vuc2UgMi4wIG9yIHRoZSBTZXJ2ZXJcbiAqIFNpZGUgUHVibGljIExpY2Vuc2UsIHYgMS5cbiAqL1xuXG5pbXBvcnQgUmVhY3QsIHsgSFRNTEF0dHJpYnV0ZXMsIEZ1bmN0aW9uQ29tcG9uZW50LCBSZWFjdE5vZGUgfSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgY2xhc3NOYW1lcyBmcm9tICdjbGFzc25hbWVzJztcbmltcG9ydCB7IENvbW1vblByb3BzIH0gZnJvbSAnLi4vY29tbW9uJztcbmltcG9ydCB7IHVzZUV1aVRoZW1lIH0gZnJvbSAnLi4vLi4vc2VydmljZXMnO1xuaW1wb3J0IHsgZXVpTWFya1N0eWxlcyB9IGZyb20gJy4vbWFyay5zdHlsZXMnO1xuZXhwb3J0IHR5cGUgRXVpTWFya1Byb3BzID0gSFRNTEF0dHJpYnV0ZXM8SFRNTEVsZW1lbnQ+ICZcbiAgQ29tbW9uUHJvcHMgJiB7XG4gICAgLyoqXG4gICAgICogUmVhY3ROb2RlIHRvIHJlbmRlciBhcyB0aGlzIGNvbXBvbmVudCdzIGNvbnRlbnRcbiAgICAgKi9cbiAgICBjaGlsZHJlbjogUmVhY3ROb2RlO1xuICB9O1xuXG5leHBvcnQgY29uc3QgRXVpTWFyazogRnVuY3Rpb25Db21wb25lbnQ8RXVpTWFya1Byb3BzPiA9ICh7XG4gIGNoaWxkcmVuLFxuICBjbGFzc05hbWUsXG4gIC4uLnJlc3Rcbn0pID0+IHtcbiAgY29uc3QgdXNlVGhlbWUgPSB1c2VFdWlUaGVtZSgpO1xuICBjb25zdCBzdHlsZXMgPSBldWlNYXJrU3R5bGVzKHVzZVRoZW1lKTtcbiAgY29uc3QgY2xhc3NlcyA9IGNsYXNzTmFtZXMoJ2V1aU1hcmsnLCBjbGFzc05hbWUpO1xuXG4gIHJldHVybiAoXG4gICAgPG1hcmsgY3NzPXtbc3R5bGVzXX0gY2xhc3NOYW1lPXtjbGFzc2VzfSB7Li4ucmVzdH0+XG4gICAgICB7Y2hpbGRyZW59XG4gICAgPC9tYXJrPlxuICApO1xufTtcbiJdfQ== */")],
    className: classes
  }, rest), children);
};

exports.EuiMark = EuiMark;