"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridFullScreenSelector = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../../services");

var _tool_tip = require("../../tool_tip");

var _button = require("../../button");

var _i18n = require("../../i18n");

var _react2 = require("@emotion/react");

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var GRID_IS_FULLSCREEN_CLASSNAME = 'euiDataGrid__restrictBody';

var useDataGridFullScreenSelector = function useDataGridFullScreenSelector() {
  var _useState = (0, _react.useState)(false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isFullScreen = _useState2[0],
      setIsFullScreen = _useState2[1];

  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiFullscreenSelector.fullscreenButton', 'euiFullscreenSelector.fullscreenButtonActive'], ['Enter fullscreen', 'Exit fullscreen']),
      _useEuiI18n2 = (0, _slicedToArray2.default)(_useEuiI18n, 2),
      fullScreenButton = _useEuiI18n2[0],
      fullScreenButtonActive = _useEuiI18n2[1];

  var controlBtnClasses = (0, _classnames.default)('euiDataGrid__controlBtn', {
    'euiDataGrid__controlBtn--active': isFullScreen
  });
  var fullScreenSelector = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      content: isFullScreen ? (0, _react2.jsx)(_react.default.Fragment, null, fullScreenButtonActive, " (", (0, _react2.jsx)("kbd", null, "esc"), ")") : fullScreenButton,
      delay: "long"
    }, (0, _react2.jsx)(_button.EuiButtonIcon, {
      size: "xs",
      iconType: isFullScreen ? 'fullScreenExit' : 'fullScreen',
      color: "text",
      className: controlBtnClasses,
      "data-test-subj": "dataGridFullScreenButton",
      onClick: function onClick() {
        return setIsFullScreen(!isFullScreen);
      },
      "aria-label": isFullScreen ? fullScreenButtonActive : fullScreenButton
    }));
  }, [isFullScreen, controlBtnClasses, fullScreenButton, fullScreenButtonActive]);
  var handleGridKeyDown = (0, _react.useCallback)(function (event) {
    switch (event.key) {
      case _services.keys.ESCAPE:
        if (isFullScreen) {
          event.preventDefault();
          setIsFullScreen(false);
        }

        break;
    }
  }, [isFullScreen]);
  (0, _react.useEffect)(function () {
    // When the data grid is fullscreen, we add a class to the body to remove the extra scrollbar and stay above any fixed headers
    if (isFullScreen) {
      document.body.classList.add(GRID_IS_FULLSCREEN_CLASSNAME);
      return function () {
        document.body.classList.remove(GRID_IS_FULLSCREEN_CLASSNAME);
      };
    }
  }, [isFullScreen]);
  return {
    isFullScreen: isFullScreen,
    setIsFullScreen: setIsFullScreen,
    fullScreenSelector: fullScreenSelector,
    handleGridKeyDown: handleGridKeyDown
  };
};

exports.useDataGridFullScreenSelector = useDataGridFullScreenSelector;