import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useState, useMemo, useCallback } from 'react';
import { EuiButtonEmpty } from '../../button';
import { EuiContextMenuItem, EuiContextMenuPanel } from '../../context_menu';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiPagination } from '../../pagination';
import { EuiPopover } from '../../popover';
import { EuiI18n } from '../../i18n';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiTablePagination = function EuiTablePagination(_ref) {
  var activePage = _ref.activePage,
      _ref$itemsPerPage = _ref.itemsPerPage,
      itemsPerPage = _ref$itemsPerPage === void 0 ? 50 : _ref$itemsPerPage,
      _ref$itemsPerPageOpti = _ref.itemsPerPageOptions,
      itemsPerPageOptions = _ref$itemsPerPageOpti === void 0 ? [10, 20, 50, 100] : _ref$itemsPerPageOpti,
      _ref$showPerPageOptio = _ref.showPerPageOptions,
      showPerPageOptions = _ref$showPerPageOptio === void 0 ? true : _ref$showPerPageOptio,
      _ref$onChangeItemsPer = _ref.onChangeItemsPerPage,
      onChangeItemsPerPage = _ref$onChangeItemsPer === void 0 ? function () {} : _ref$onChangeItemsPer,
      onChangePage = _ref.onChangePage,
      pageCount = _ref.pageCount,
      rest = _objectWithoutProperties(_ref, ["activePage", "itemsPerPage", "itemsPerPageOptions", "showPerPageOptions", "onChangeItemsPerPage", "onChangePage", "pageCount"]);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isPopoverOpen = _useState2[0],
      setIsPopoverOpen = _useState2[1];

  var togglePopover = useCallback(function () {
    setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = useCallback(function () {
    setIsPopoverOpen(false);
  }, []);

  var button = ___EmotionJSX(EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": "tablePaginationPopoverButton",
    onClick: togglePopover
  }, itemsPerPage === 0 ? ___EmotionJSX(EuiI18n, {
    token: "euiTablePagination.allRows",
    default: "Showing all rows"
  }) : ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiI18n, {
    token: "euiTablePagination.rowsPerPage",
    default: "Rows per page"
  }), ": ", itemsPerPage));

  var items = useMemo(function () {
    return itemsPerPageOptions.map(function (itemsPerPageOption) {
      return ___EmotionJSX(EuiContextMenuItem, {
        key: itemsPerPageOption,
        icon: itemsPerPageOption === itemsPerPage ? 'check' : 'empty',
        onClick: function onClick() {
          closePopover();
          onChangeItemsPerPage(itemsPerPageOption);
        },
        "data-test-subj": "tablePagination-".concat(itemsPerPageOption, "-rows")
      }, itemsPerPageOption === 0 ? ___EmotionJSX(EuiI18n, {
        token: "euiTablePagination.rowsPerPageOptionShowAllRows",
        default: "Show all rows"
      }) : ___EmotionJSX(EuiI18n, {
        token: "euiTablePagination.rowsPerPageOption",
        values: {
          rowsPerPage: itemsPerPageOption
        },
        default: "{rowsPerPage} rows"
      }));
    });
  }, [itemsPerPageOptions, itemsPerPage, onChangeItemsPerPage, closePopover]);

  var itemsPerPagePopover = ___EmotionJSX(EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upRight"
  }, ___EmotionJSX(EuiContextMenuPanel, {
    items: items
  }));

  return ___EmotionJSX(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true,
    gutterSize: "s",
    className: "eui-xScroll"
  }, ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, showPerPageOptions && itemsPerPagePopover), ___EmotionJSX(EuiFlexItem, {
    grow: false
  }, itemsPerPage > 0 && ___EmotionJSX(EuiPagination, _extends({
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: onChangePage
  }, rest))));
};