"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTablePagination = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _button = require("../../button");

var _context_menu = require("../../context_menu");

var _flex = require("../../flex");

var _pagination = require("../../pagination");

var _popover = require("../../popover");

var _i18n = require("../../i18n");

var _react2 = require("@emotion/react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiTablePagination = function EuiTablePagination(_ref) {
  var activePage = _ref.activePage,
      _ref$itemsPerPage = _ref.itemsPerPage,
      itemsPerPage = _ref$itemsPerPage === void 0 ? 50 : _ref$itemsPerPage,
      _ref$itemsPerPageOpti = _ref.itemsPerPageOptions,
      itemsPerPageOptions = _ref$itemsPerPageOpti === void 0 ? [10, 20, 50, 100] : _ref$itemsPerPageOpti,
      _ref$showPerPageOptio = _ref.showPerPageOptions,
      showPerPageOptions = _ref$showPerPageOptio === void 0 ? true : _ref$showPerPageOptio,
      _ref$onChangeItemsPer = _ref.onChangeItemsPerPage,
      onChangeItemsPerPage = _ref$onChangeItemsPer === void 0 ? function () {} : _ref$onChangeItemsPer,
      onChangePage = _ref.onChangePage,
      pageCount = _ref.pageCount,
      rest = _objectWithoutProperties(_ref, ["activePage", "itemsPerPage", "itemsPerPageOptions", "showPerPageOptions", "onChangeItemsPerPage", "onChangePage", "pageCount"]);

  var _useState = (0, _react.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      isPopoverOpen = _useState2[0],
      setIsPopoverOpen = _useState2[1];

  var togglePopover = (0, _react.useCallback)(function () {
    setIsPopoverOpen(function (isOpen) {
      return !isOpen;
    });
  }, []);
  var closePopover = (0, _react.useCallback)(function () {
    setIsPopoverOpen(false);
  }, []);
  var button = (0, _react2.jsx)(_button.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    iconType: "arrowDown",
    iconSide: "right",
    "data-test-subj": "tablePaginationPopoverButton",
    onClick: togglePopover
  }, itemsPerPage === 0 ? (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTablePagination.allRows",
    default: "Showing all rows"
  }) : (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiTablePagination.rowsPerPage",
    default: "Rows per page"
  }), ": ", itemsPerPage));
  var items = (0, _react.useMemo)(function () {
    return itemsPerPageOptions.map(function (itemsPerPageOption) {
      return (0, _react2.jsx)(_context_menu.EuiContextMenuItem, {
        key: itemsPerPageOption,
        icon: itemsPerPageOption === itemsPerPage ? 'check' : 'empty',
        onClick: function onClick() {
          closePopover();
          onChangeItemsPerPage(itemsPerPageOption);
        },
        "data-test-subj": "tablePagination-".concat(itemsPerPageOption, "-rows")
      }, itemsPerPageOption === 0 ? (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTablePagination.rowsPerPageOptionShowAllRows",
        default: "Show all rows"
      }) : (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiTablePagination.rowsPerPageOption",
        values: {
          rowsPerPage: itemsPerPageOption
        },
        default: "{rowsPerPage} rows"
      }));
    });
  }, [itemsPerPageOptions, itemsPerPage, onChangeItemsPerPage, closePopover]);
  var itemsPerPagePopover = (0, _react2.jsx)(_popover.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upRight"
  }, (0, _react2.jsx)(_context_menu.EuiContextMenuPanel, {
    items: items
  }));
  return (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false,
    wrap: true,
    gutterSize: "s",
    className: "eui-xScroll"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, showPerPageOptions && itemsPerPagePopover), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, itemsPerPage > 0 && (0, _react2.jsx)(_pagination.EuiPagination, _extends({
    pageCount: pageCount,
    activePage: activePage,
    onPageClick: onChangePage
  }, rest))));
};

exports.EuiTablePagination = EuiTablePagination;
EuiTablePagination.propTypes = {
  /**
     * Option to completely hide the "Rows per page" selector.
     */
  showPerPageOptions: _propTypes.default.bool,

  /**
     * Current selection for "Rows per page".
     * Pass `0` to display the selected "Show all" option and hide the pagination.
     */
  itemsPerPage: _propTypes.default.number,

  /**
     * Custom array of options for "Rows per page".
     * Pass `0` as one of the options to create a "Show all" option.
     */
  itemsPerPageOptions: _propTypes.default.arrayOf(_propTypes.default.number.isRequired),

  /**
     * Click handler that passes back selected `pageSize` number
     */
  onChangeItemsPerPage: _propTypes.default.func,
  onChangePage: _propTypes.default.func,

  /**
     * Requires the `id` of the table being controlled
     */
  "aria-controls": _propTypes.default.string,
  "aria-label": _propTypes.default.string
};