"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMark = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _services = require("../../services");

var _mark = require("./mark.styles");

var _react2 = require("@emotion/react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var EuiMark = function EuiMark(_ref) {
  var children = _ref.children,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["children", "className"]);

  var useTheme = (0, _services.useEuiTheme)();
  var styles = (0, _mark.euiMarkStyles)(useTheme);
  var classes = (0, _classnames.default)('euiMark', className);
  return (0, _react2.jsx)("mark", _extends({
    css: [styles, ";label:EuiMark;" + (process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb21wb25lbnRzL21hcmsvbWFyay50c3giXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBK0JVIiwiZmlsZSI6Ii4uLy4uLy4uL3NyYy9jb21wb25lbnRzL21hcmsvbWFyay50c3giLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IEVsYXN0aWNzZWFyY2ggQi5WLiBhbmQvb3IgbGljZW5zZWQgdG8gRWxhc3RpY3NlYXJjaCBCLlYuIHVuZGVyIG9uZVxuICogb3IgbW9yZSBjb250cmlidXRvciBsaWNlbnNlIGFncmVlbWVudHMuIExpY2Vuc2VkIHVuZGVyIHRoZSBFbGFzdGljIExpY2Vuc2VcbiAqIDIuMCBhbmQgdGhlIFNlcnZlciBTaWRlIFB1YmxpYyBMaWNlbnNlLCB2IDE7IHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0XG4gKiBpbiBjb21wbGlhbmNlIHdpdGgsIGF0IHlvdXIgZWxlY3Rpb24sIHRoZSBFbGFzdGljIExpY2Vuc2UgMi4wIG9yIHRoZSBTZXJ2ZXJcbiAqIFNpZGUgUHVibGljIExpY2Vuc2UsIHYgMS5cbiAqL1xuaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcbmltcG9ydCBjbGFzc05hbWVzIGZyb20gJ2NsYXNzbmFtZXMnO1xuaW1wb3J0IHsgdXNlRXVpVGhlbWUgfSBmcm9tICcuLi8uLi9zZXJ2aWNlcyc7XG5pbXBvcnQgeyBldWlNYXJrU3R5bGVzIH0gZnJvbSAnLi9tYXJrLnN0eWxlcyc7XG5leHBvcnQgdmFyIEV1aU1hcmsgPSAoe1xuICBjaGlsZHJlbixcbiAgY2xhc3NOYW1lLFxuICAuLi5yZXN0XG59KSA9PiB7XG4gIGNvbnN0IHVzZVRoZW1lID0gdXNlRXVpVGhlbWUoKTtcbiAgY29uc3Qgc3R5bGVzID0gZXVpTWFya1N0eWxlcyh1c2VUaGVtZSk7XG4gIGNvbnN0IGNsYXNzZXMgPSBjbGFzc05hbWVzKCdldWlNYXJrJywgY2xhc3NOYW1lKTtcbiAgcmV0dXJuIDxtYXJrIGNzcz17W3N0eWxlc119IGNsYXNzTmFtZT17Y2xhc3Nlc30gey4uLnJlc3R9PlxuICAgICAge2NoaWxkcmVufVxuICAgIDwvbWFyaz47XG59O1xuRXVpTWFyay5wcm9wVHlwZXMgPSB7XG4gIGNsYXNzTmFtZTogUHJvcFR5cGVzLnN0cmluZyxcbiAgXCJhcmlhLWxhYmVsXCI6IFByb3BUeXBlcy5zdHJpbmcsXG4gIFwiZGF0YS10ZXN0LXN1YmpcIjogUHJvcFR5cGVzLnN0cmluZyxcblxuICAvKipcbiAgICAgICAqIFJlYWN0Tm9kZSB0byByZW5kZXIgYXMgdGhpcyBjb21wb25lbnQncyBjb250ZW50XG4gICAgICAgKi9cbiAgY2hpbGRyZW46IFByb3BUeXBlcy5ub2RlLmlzUmVxdWlyZWRcbn07Il19 */")],
    className: classes
  }, rest), children);
};

exports.EuiMark = EuiMark;
EuiMark.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * ReactNode to render as this component's content
       */
  children: _propTypes.default.node.isRequired
};