function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
import React, { useEffect, useCallback } from 'react';
import classNames from 'classnames';
import { EuiFieldSearch } from '../../form';
import { getMatchingOptions } from '../matching_options';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSelectableSearch = function EuiSelectableSearch(_ref) {
  var onChangeCallback = _ref.onChange,
      options = _ref.options,
      value = _ref.value,
      placeholder = _ref.placeholder,
      isPreFiltered = _ref.isPreFiltered,
      listId = _ref.listId,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["onChange", "options", "value", "placeholder", "isPreFiltered", "listId", "className"]);

  useEffect(function () {
    var matchingOptions = getMatchingOptions(options, value, isPreFiltered);
    onChangeCallback(value, matchingOptions); // Call on mount only
  }, []); // eslint-disable-line react-hooks/exhaustive-deps

  var onChange = useCallback(function (e) {
    var searchValue = e.target.value;
    var matchingOptions = getMatchingOptions(options, searchValue, isPreFiltered);
    onChangeCallback(searchValue, matchingOptions);
  }, [options, isPreFiltered, onChangeCallback]);
  var classes = classNames('euiSelectableSearch', className);
  var ariaPropsIfListIsPresent = listId ? {
    role: 'combobox',
    'aria-autocomplete': 'list',
    'aria-expanded': true,
    'aria-controls': listId,
    'aria-owns': listId // legacy attribute but shims support for nearly everything atm

  } : undefined;
  return ___EmotionJSX(EuiFieldSearch, _extends({
    className: classes,
    placeholder: placeholder,
    value: value,
    onChange: onChange,
    incremental: true,
    fullWidth: true,
    autoComplete: "off",
    "aria-haspopup": "listbox"
  }, ariaPropsIfListIsPresent, rest));
};