"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderXYChartCanvas2d = void 0;
var colors_1 = require("../../../../common/colors");
var canvas_1 = require("../../../../renderers/canvas");
var annotations_1 = require("./annotations");
var areas_1 = require("./areas");
var bars_1 = require("./bars");
var bubbles_1 = require("./bubbles");
var grids_1 = require("./grids");
var lines_1 = require("./lines");
var panels_1 = require("./panels/panels");
var debug_1 = require("./utils/debug");
var bar_1 = require("./values/bar");
function renderXYChartCanvas2d(ctx, dpr, clippings, props) {
    var imgCanvas = document.createElement('canvas');
    (0, canvas_1.withContext)(ctx, function () {
        ctx.scale(dpr, dpr);
        var renderingArea = props.renderingArea, chartTransform = props.chartTransform, rotation = props.rotation, geometries = props.geometries, geometriesIndex = props.geometriesIndex, _a = props.theme, sharedAxesStyle = _a.axes, sharedStyle = _a.sharedStyle, barSeriesStyle = _a.barSeriesStyle, background = _a.background, highlightedLegendItem = props.highlightedLegendItem, annotationDimensions = props.annotationDimensions, annotationSpecs = props.annotationSpecs, perPanelAxisGeoms = props.perPanelAxisGeoms, perPanelGridLines = props.perPanelGridLines, axesSpecs = props.axesSpecs, axesStyles = props.axesStyles, debug = props.debug, panelGeoms = props.panelGeoms;
        var transform = { x: renderingArea.left + chartTransform.x, y: renderingArea.top + chartTransform.y };
        (0, canvas_1.renderLayers)(ctx, [
            function () { return (0, canvas_1.clearCanvas)(ctx, 'transparent'); },
            function () { return debug && (0, panels_1.renderGridPanels)(ctx, transform, panelGeoms); },
            function () {
                return (0, grids_1.renderGrids)(ctx, {
                    axesSpecs: axesSpecs,
                    renderingArea: renderingArea,
                    perPanelGridLines: perPanelGridLines,
                    axesStyles: axesStyles,
                    sharedAxesStyle: sharedAxesStyle,
                });
            },
            function () {
                return (0, panels_1.renderPanelSubstrates)(ctx, {
                    axesSpecs: axesSpecs,
                    perPanelAxisGeoms: perPanelAxisGeoms,
                    renderingArea: renderingArea,
                    debug: debug,
                    axesStyles: axesStyles,
                    sharedAxesStyle: sharedAxesStyle,
                });
            },
            function () { return (0, annotations_1.renderAnnotations)(ctx, { rotation: rotation, renderingArea: renderingArea, annotationDimensions: annotationDimensions, annotationSpecs: annotationSpecs }, true); },
            function () {
                return (0, bars_1.renderBars)(ctx, imgCanvas, geometries.bars, sharedStyle, clippings, renderingArea, highlightedLegendItem, rotation);
            },
            function () {
                return (0, areas_1.renderAreas)(ctx, imgCanvas, {
                    areas: geometries.areas,
                    clippings: clippings,
                    renderingArea: renderingArea,
                    rotation: rotation,
                    highlightedLegendItem: highlightedLegendItem,
                    sharedStyle: sharedStyle,
                });
            },
            function () {
                return (0, lines_1.renderLines)(ctx, {
                    lines: geometries.lines,
                    clippings: clippings,
                    renderingArea: renderingArea,
                    rotation: rotation,
                    highlightedLegendItem: highlightedLegendItem,
                    sharedStyle: sharedStyle,
                });
            },
            function () {
                return (0, bubbles_1.renderBubbles)(ctx, {
                    bubbles: geometries.bubbles,
                    clippings: clippings,
                    highlightedLegendItem: highlightedLegendItem,
                    sharedStyle: sharedStyle,
                    rotation: rotation,
                    renderingArea: renderingArea,
                });
            },
            function () {
                return geometries.bars.forEach(function (_a) {
                    var bars = _a.value, panel = _a.panel;
                    return (0, bar_1.renderBarValues)(ctx, {
                        bars: bars,
                        panel: panel,
                        renderingArea: renderingArea,
                        rotation: rotation,
                        debug: debug,
                        barSeriesStyle: barSeriesStyle,
                        background: background,
                    });
                });
            },
            function () { return (0, annotations_1.renderAnnotations)(ctx, { annotationDimensions: annotationDimensions, annotationSpecs: annotationSpecs, rotation: rotation, renderingArea: renderingArea }, false); },
            function () {
                return debug &&
                    (0, canvas_1.withContext)(ctx, function () {
                        var _a;
                        var left = renderingArea.left, top = renderingArea.top, width = renderingArea.width, height = renderingArea.height;
                        (0, debug_1.renderDebugRect)(ctx, { x: left, y: top, width: width, height: height }, 0, { color: colors_1.Colors.Transparent.rgba }, { color: colors_1.Colors.Red.rgba, width: 4, dash: [4, 4] });
                        var renderer = (_a = geometriesIndex.triangulation([0, 0, width, height])) === null || _a === void 0 ? void 0 : _a.render;
                        if ((0, canvas_1.isCanvasRenderer)(renderer)) {
                            ctx.beginPath();
                            ctx.translate(left, top);
                            ctx.setLineDash([5, 5]);
                            renderer(ctx);
                            ctx.lineWidth = 1;
                            ctx.strokeStyle = 'blue';
                            ctx.stroke();
                        }
                    });
            },
        ]);
    });
}
exports.renderXYChartCanvas2d = renderXYChartCanvas2d;
//# sourceMappingURL=renderers.js.map