"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostCountContext = exports.useHostCount = exports.HostCountProvider = exports.HostCount = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _react = require("react");
var _use_kibana = require("../../../../hooks/use_kibana");
var _http_api = require("../../../../../common/http_api");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_unified_search = require("./use_unified_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostCount = () => {
  var _data$count2;
  const {
    buildQuery,
    parsedDateRange,
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    telemetry
  } = services;
  const payload = (0, _react.useMemo)(() => JSON.stringify({
    query: buildQuery(),
    from: parsedDateRange.from,
    to: parsedDateRange.to
  }), [buildQuery, parsedDateRange]);
  const {
    data,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/infra/host/count', {
      method: 'POST',
      body: payload
    });
    return (0, _ioTsUtils.decodeOrThrow)(_http_api.GetInfraAssetCountResponsePayloadRT)(response);
  }, [payload]);
  (0, _react.useEffect)(() => {
    if (data && !error) {
      var _data$count;
      telemetry.reportHostsViewTotalHostCountRetrieved({
        total: (_data$count = data.count) !== null && _data$count !== void 0 ? _data$count : 0,
        with_query: !!searchCriteria.query.query,
        with_filters: searchCriteria.filters.length > 0 || searchCriteria.panelFilters.length > 0
      });
    }
  }, [data, error, payload, searchCriteria, telemetry]);
  return {
    errors: error,
    loading: (0, _use_fetcher.isPending)(status),
    count: (_data$count2 = data === null || data === void 0 ? void 0 : data.count) !== null && _data$count2 !== void 0 ? _data$count2 : 0
  };
};
exports.useHostCount = useHostCount;
const HostCount = exports.HostCount = (0, _constate.default)(useHostCount);
const [HostCountProvider, useHostCountContext] = HostCount;
exports.useHostCountContext = useHostCountContext;
exports.HostCountProvider = HostCountProvider;