"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamPageLogsContentForState = exports.StreamPageLogsContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _common2 = require("@kbn/logs-shared-plugin/common");
var _public = require("@kbn/logs-shared-plugin/public");
var _react = require("@xstate/react");
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _react2 = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _logs_deprecation_callout = require("../../../components/logs_deprecation_callout");
var _auto_sizer = require("../../../components/auto_sizer");
var _log_minimap = require("../../../components/logging/log_minimap");
var _page = require("../../../components/page");
var _log_flyout = require("../../../containers/logs/log_flyout");
var _log_view_configuration = require("../../../containers/logs/log_view_configuration");
var _view_log_in_context = require("../../../containers/logs/view_log_in_context");
var _with_log_textview = require("../../../containers/logs/with_log_textview");
var _use_kibana = require("../../../hooks/use_kibana");
var _state = require("../../../observability_logs/log_stream_page/state");
var _datemath = require("../../../utils/datemath");
var _page_toolbar = require("./page_toolbar");
var _page_view_log_in_context = require("./page_view_log_in_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_THRESHOLD = 2;
const StreamPageLogsContent = exports.StreamPageLogsContent = /*#__PURE__*/_react2.default.memo(({
  filterQuery,
  logStreamPageCallbacks
}) => {
  const {
    data: {
      query: {
        queryString
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const {
    resolvedLogView,
    logView,
    logViewReference
  } = (0, _public.useLogViewContext)();
  const {
    textScale,
    textWrap
  } = (0, _log_view_configuration.useLogViewConfigurationContext)();
  const {
    surroundingLogsId,
    setSurroundingLogsId,
    closeFlyout: closeLogEntryFlyout,
    openFlyout: openLogEntryFlyout,
    isFlyoutOpen,
    logEntryId: flyoutLogEntryId
  } = (0, _log_flyout.useLogEntryFlyoutContext)();
  const {
    startTimestamp,
    endTimestamp,
    isStreaming,
    targetPosition,
    visibleMidpointTime,
    visibleTimeInterval,
    reportVisiblePositions,
    jumpToTargetPosition,
    startLiveStreaming,
    stopLiveStreaming,
    startDateExpression,
    endDateExpression,
    updateDateRange,
    lastCompleteDateRangeExpressionUpdate
  } = (0, _public.useLogPositionStateContext)();
  const {
    isReloading,
    entries,
    topCursor,
    bottomCursor,
    hasMoreAfter: hasMoreAfterEnd,
    hasMoreBefore: hasMoreBeforeStart,
    isLoadingMore,
    lastLoadedTime,
    fetchEntries,
    fetchPreviousEntries,
    fetchNextEntries,
    fetchNewestEntries
  } = (0, _public.useLogStreamContext)();
  const prevStartTimestamp = (0, _usePrevious.default)(startTimestamp);
  const prevEndTimestamp = (0, _usePrevious.default)(endTimestamp);
  const prevFilterQuery = (0, _usePrevious.default)(filterQuery);
  const prevLastCompleteDateRangeExpressionUpdate = (0, _usePrevious.default)(lastCompleteDateRangeExpressionUpdate);

  // Refetch entries if...
  (0, _react2.useEffect)(() => {
    const isFirstLoad = !prevStartTimestamp || !prevEndTimestamp;
    const completeDateRangeExpressionHasChanged = lastCompleteDateRangeExpressionUpdate !== prevLastCompleteDateRangeExpressionUpdate;
    const isCenterPointOutsideLoadedRange = targetPosition != null && (topCursor != null && (0, _common2.convertISODateToNanoPrecision)(targetPosition.time) < (0, _common2.convertISODateToNanoPrecision)(topCursor.time) || bottomCursor != null && (0, _common2.convertISODateToNanoPrecision)(targetPosition.time) > (0, _common2.convertISODateToNanoPrecision)(bottomCursor.time));
    const hasQueryChanged = filterQuery !== prevFilterQuery;
    if (isFirstLoad || completeDateRangeExpressionHasChanged || isCenterPointOutsideLoadedRange || hasQueryChanged) {
      if (isStreaming) {
        fetchNewestEntries();
      } else {
        fetchEntries();
      }
    }
  }, [fetchEntries, fetchNewestEntries, isStreaming, prevStartTimestamp, prevEndTimestamp, startTimestamp, endTimestamp, targetPosition, topCursor, bottomCursor, filterQuery, prevFilterQuery, lastCompleteDateRangeExpressionUpdate, prevLastCompleteDateRangeExpressionUpdate]);
  const {
    logSummaryHighlights,
    currentHighlightKey,
    logEntryHighlightsById
  } = (0, _public.useLogHighlightsStateContext)();
  const items = (0, _react2.useMemo)(() => isReloading ? [] : entries.map(logEntry => createLogEntryStreamItem(logEntry, logEntryHighlightsById[logEntry.id] || [])), [entries, isReloading, logEntryHighlightsById]);
  const [, {
    setContextEntry
  }] = (0, _view_log_in_context.useViewLogInProviderContext)();
  const handleDateRangeExtension = (0, _react2.useCallback)(newDateRange => {
    updateDateRange(newDateRange);
    if (newDateRange.startDateExpression != null && (0, _datemath.isValidDatemath)(newDateRange.startDateExpression)) {
      fetchPreviousEntries({
        force: true,
        extendTo: (0, _datemath.datemathToEpochMillis)(newDateRange.startDateExpression)
      });
    }
    if (newDateRange.endDateExpression != null && (0, _datemath.isValidDatemath)(newDateRange.endDateExpression)) {
      fetchNextEntries({
        force: true,
        extendTo: (0, _datemath.datemathToEpochMillis)(newDateRange.endDateExpression)
      });
    }
  }, [updateDateRange, fetchPreviousEntries, fetchNextEntries]);
  const handlePagination = (0, _react2.useCallback)(params => {
    reportVisiblePositions(params);
    if (!params.fromScroll) {
      return;
    }
    if (isLoadingMore) {
      return;
    }
    if (params.pagesBeforeStart < PAGE_THRESHOLD) {
      fetchPreviousEntries();
    } else if (params.pagesAfterEnd < PAGE_THRESHOLD) {
      fetchNextEntries();
    }
  }, [reportVisiblePositions, isLoadingMore, fetchPreviousEntries, fetchNextEntries]);
  const setFilter = (0, _react2.useCallback)((filter, flyoutItemId, timeKey) => {
    queryString.setQuery(filter);
    if (timeKey) {
      jumpToTargetPosition(timeKey);
    }
    setSurroundingLogsId(flyoutItemId);
    stopLiveStreaming();
  }, [jumpToTargetPosition, queryString, setSurroundingLogsId, stopLiveStreaming]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_logs_deprecation_callout.LogsDeprecationCallout, {
    page: "stream"
  }), /*#__PURE__*/_react2.default.createElement(_with_log_textview.WithLogTextviewUrlState, null), /*#__PURE__*/_react2.default.createElement(_log_flyout.WithFlyoutOptionsUrlState, null), /*#__PURE__*/_react2.default.createElement(_page_toolbar.LogsToolbar, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_page_view_log_in_context.PageViewLogInContext, null), isFlyoutOpen ? /*#__PURE__*/_react2.default.createElement(_public.LogEntryFlyout, {
    logEntryId: flyoutLogEntryId,
    onCloseFlyout: closeLogEntryFlyout,
    onSetFieldFilter: setFilter,
    logViewReference: logViewReference
  }) : null, /*#__PURE__*/_react2.default.createElement(_page.PageContent, {
    key: `${logViewReference.type === 'log-view-reference' ? logViewReference.logViewId : logViewReference.id}-${logView === null || logView === void 0 ? void 0 : logView.version}`
  }, /*#__PURE__*/_react2.default.createElement(_public.ScrollableLogTextStreamView, {
    columnConfigurations: resolvedLogView && resolvedLogView.columns || [],
    hasMoreAfterEnd: hasMoreAfterEnd,
    hasMoreBeforeStart: hasMoreBeforeStart,
    isLoadingMore: isLoadingMore,
    isReloading: isReloading,
    isStreaming: isStreaming,
    items: items,
    jumpToTarget: jumpToTargetPosition,
    lastLoadedTime: lastLoadedTime,
    reloadItems: fetchEntries,
    reportVisibleInterval: handlePagination,
    scale: textScale,
    target: targetPosition,
    wrap: textWrap,
    onOpenLogEntryFlyout: openLogEntryFlyout,
    setContextEntry: setContextEntry,
    highlightedItem: surroundingLogsId ? surroundingLogsId : null,
    currentHighlightKey: currentHighlightKey,
    startDateExpression: startDateExpression,
    endDateExpression: endDateExpression,
    updateDateRange: handleDateRangeExtension,
    startLiveStreaming: startLiveStreaming
  }), /*#__PURE__*/_react2.default.createElement(_auto_sizer.AutoSizer, {
    content: true,
    bounds: true,
    detectAnyWindowResize: "height"
  }, ({
    measureRef,
    bounds: {
      height = 0
    },
    content: {
      width = 0
    }
  }) => {
    return /*#__PURE__*/_react2.default.createElement(LogPageMinimapColumn, {
      ref: measureRef
    }, /*#__PURE__*/_react2.default.createElement(WithSummaryAndQuery, null, ({
      buckets,
      start,
      end
    }) => /*#__PURE__*/_react2.default.createElement(_log_minimap.LogMinimap, {
      start: start,
      end: end,
      height: height,
      width: width,
      highlightedInterval: isReloading ? null : visibleTimeInterval,
      jumpToTarget: jumpToTargetPosition,
      summaryBuckets: buckets,
      summaryHighlightBuckets: logSummaryHighlights.length > 0 ? logSummaryHighlights[0].buckets : [],
      target: visibleMidpointTime
    })));
  })));
});
const WithSummaryAndQuery = props => {
  const serializedParsedQuery = (0, _react.useSelector)((0, _state.useLogStreamPageStateContext)(), logStreamPageState => logStreamPageState.matches({
    hasLogViewIndices: 'initialized'
  }) ? (0, _jsonStableStringify.default)(logStreamPageState.context.parsedQuery) : null);
  return /*#__PURE__*/_react2.default.createElement(_public.WithSummary, (0, _extends2.default)({
    serializedParsedQuery: serializedParsedQuery
  }, props));
};
const StreamPageLogsContentForState = exports.StreamPageLogsContentForState = /*#__PURE__*/_react2.default.memo(({
  logStreamPageState,
  logStreamPageCallbacks
}) => {
  const {
    context: {
      parsedQuery
    }
  } = logStreamPageState;
  return /*#__PURE__*/_react2.default.createElement(StreamPageLogsContent, {
    filterQuery: parsedQuery,
    logStreamPageCallbacks: logStreamPageCallbacks
  });
});
const LogPageMinimapColumn = _common.euiStyled.div`
  flex: 1 0 0%;
  overflow: hidden;
  min-width: 100px;
  max-width: 100px;
  display: flex;
  flex-direction: column;
`;
const createLogEntryStreamItem = (logEntry, highlights) => ({
  kind: 'logEntry',
  logEntry,
  highlights
});