"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualisationContent = exports.AnomaliesSwimlaneVisualisation = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/ml-plugin/public");
var _missing_embeddable_factory_callout = require("../../../../../components/missing_embeddable_factory_callout");
var _infra_ml = require("../../../../../../common/infra_ml");
var _use_kibana = require("../../../../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Disable refresh, allow our timerange changes to refresh the embeddable.
const REFRESH_CONFIG = {
  pause: true,
  value: 0
};
const AnomaliesSwimlaneVisualisation = props => {
  const {
    embeddable: embeddablePlugin
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  if (!embeddablePlugin) return null;
  return /*#__PURE__*/_react.default.createElement(VisualisationContent, props);
};
exports.AnomaliesSwimlaneVisualisation = AnomaliesSwimlaneVisualisation;
const VisualisationContent = ({
  timeRange,
  jobIds,
  selectedDatasets
}) => {
  const {
    ml
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const formattedTimeRange = (0, _react.useMemo)(() => {
    return {
      from: (0, _moment.default)(timeRange.startTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ'),
      to: (0, _moment.default)(timeRange.endTime).format('YYYY-MM-DDTHH:mm:ss.SSSZ')
    };
  }, [timeRange.startTime, timeRange.endTime]);
  const query = (0, _react.useMemo)(() => {
    return {
      language: 'kuery',
      query: selectedDatasets.map(dataset => `${_infra_ml.partitionField} : ${dataset !== '' ? dataset : '""'}`).join(' or ') // Ensure unknown (those with an empty "" string) datasets are handled correctly.
    };
  }, [selectedDatasets]);
  const AnomalySwimLane = ml === null || ml === void 0 ? void 0 : ml.components.AnomalySwimLane;
  if (!AnomalySwimLane) {
    return /*#__PURE__*/_react.default.createElement(_missing_embeddable_factory_callout.MissingEmbeddableFactoryCallout, {
      embeddableType: _public.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE
    });
  }
  return /*#__PURE__*/_react.default.createElement(AnomalySwimLane, {
    id: "LOG_ENTRY_ANOMALIES_EMBEDDABLE_INSTANCE",
    executionContext: {
      name: 'infra_logs'
    },
    jobIds: jobIds,
    swimlaneType: "viewBy",
    viewBy: _infra_ml.partitionField,
    refreshConfig: REFRESH_CONFIG,
    timeRange: formattedTimeRange,
    query: query
  });
};
exports.VisualisationContent = VisualisationContent;