"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySeverityIndicatorList = void 0;
var _react = _interopRequireDefault(require("react"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _anomaly_severity_indicator = require("../../../../../components/logging/log_analysis_results/anomaly_severity_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalySeverityIndicatorList = ({
  datasets
}) => /*#__PURE__*/_react.default.createElement("ul", null, datasets.map(dataset => {
  const datasetLabel = (0, _log_analysis.getFriendlyNameForPartitionId)(dataset.name);
  return /*#__PURE__*/_react.default.createElement("li", {
    key: datasetLabel
  }, /*#__PURE__*/_react.default.createElement(_anomaly_severity_indicator.AnomalySeverityIndicator, {
    anomalyScore: dataset.maximumAnomalyScore
  }));
}));
exports.AnomalySeverityIndicatorList = AnomalySeverityIndicatorList;