"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorPageBody = exports.Error = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _page = require("../components/page");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailPageContent = (0, _common.euiStyled)(_page.PageContent)`
  overflow: auto;
  background-color: ${props => props.theme.eui.euiColorLightestShade};
`;
const Error = ({
  message
}) => {
  return /*#__PURE__*/_react.default.createElement(_page.ColumnarPage, null, /*#__PURE__*/_react.default.createElement(DetailPageContent, null, /*#__PURE__*/_react.default.createElement(ErrorPageBody, {
    message: message
  })));
};
exports.Error = Error;
const ErrorPageBody = ({
  message
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    restrictWidth: false,
    bottomBorder: false,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Header, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.errorPage.unexpectedErrorTitle",
    defaultMessage: "Oops!"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: message,
    iconType: "error"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.errorPage.tryAgainDescription ",
    defaultMessage: "Please click the back button and try again."
  })))));
};
exports.ErrorPageBody = ErrorPageBody;