"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitForInitialQueryParameters = exports.waitForInitialPositionParameters = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const waitForInitialQueryParameters = () => (_context, _event) => (send, onEvent) => {
  // constituents of the set of initial parameters
  let latestValidQuery;
  let latestTimeRange;
  let latestRefreshInterval;
  let latestTimestamps;
  onEvent(event => {
    switch (event.type) {
      // event types that deliver the parameters
      case 'VALID_QUERY_CHANGED':
      case 'INVALID_QUERY_CHANGED':
        latestValidQuery = event.parsedQuery;
        break;
      case 'TIME_CHANGED':
        latestTimeRange = event.timeRange;
        latestRefreshInterval = event.refreshInterval;
        latestTimestamps = event.timestamps;
        break;
    }

    // if all constituents of the parameters have been delivered
    if (latestValidQuery !== undefined && latestTimeRange !== undefined && latestRefreshInterval !== undefined && latestTimestamps !== undefined) {
      send({
        type: 'RECEIVED_INITIAL_QUERY_PARAMETERS',
        validatedQuery: latestValidQuery,
        timeRange: latestTimeRange,
        refreshInterval: latestRefreshInterval,
        timestamps: latestTimestamps
      });
    }
  });
};
exports.waitForInitialQueryParameters = waitForInitialQueryParameters;
const waitForInitialPositionParameters = () => (_context, _event) => (send, onEvent) => {
  // constituents of the set of initial parameters
  let latestTargetPosition;
  let latestLatestPosition;
  let latestVisiblePositions;
  onEvent(event => {
    switch (event.type) {
      case 'POSITIONS_CHANGED':
        latestTargetPosition = event.targetPosition;
        latestLatestPosition = event.latestPosition;
        latestVisiblePositions = event.visiblePositions;
        break;
    }

    // if all constituents of the parameters have been delivered
    if (latestTargetPosition !== undefined && latestLatestPosition !== undefined && latestVisiblePositions !== undefined) {
      send({
        type: 'RECEIVED_INITIAL_POSITION_PARAMETERS',
        targetPosition: latestTargetPosition,
        latestPosition: latestLatestPosition,
        visiblePositions: latestVisiblePositions
      });
    }
  });
};
exports.waitForInitialPositionParameters = waitForInitialPositionParameters;