"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogsBreadcrumbs = void 0;
var _public = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../common/constants");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogsBreadcrumbs = extraCrumbs => {
  const appLinkProps = (0, _public.useLinkProps)({
    app: _constants.LOGS_APP
  });
  const breadcrumbs = [{
    ...appLinkProps,
    text: _translations.logsTitle
  }, ...extraCrumbs];
  (0, _public.useBreadcrumbs)(breadcrumbs, {
    classicOnly: true
  });
};
exports.useLogsBreadcrumbs = useLogsBreadcrumbs;