"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryCategoriesSetup = void 0;
var _log_analysis_setup_state = require("../../log_analysis_setup_state");
var _use_log_entry_categories_module = require("./use_log_entry_categories_module");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryCategoriesSetup = () => {
  const {
    categoryQualityWarnings,
    cleanUpAndSetUpModule,
    fetchJobStatus,
    lastSetupErrorMessages,
    moduleDescriptor,
    setUpModule,
    setupStatus,
    sourceConfiguration,
    viewResults
  } = (0, _use_log_entry_categories_module.useLogEntryCategoriesModuleContext)();
  const {
    cleanUpAndSetUp,
    endTime,
    isValidating,
    setEndTime,
    setStartTime,
    setValidatedIndices,
    setUp,
    startTime,
    validatedIndices,
    validationErrors
  } = (0, _log_analysis_setup_state.useAnalysisSetupState)({
    cleanUpAndSetUpModule,
    moduleDescriptor,
    setUpModule,
    sourceConfiguration
  });
  return {
    categoryQualityWarnings,
    cleanUpAndSetUp,
    endTime,
    fetchJobStatus,
    isValidating,
    lastSetupErrorMessages,
    moduleDescriptor,
    setEndTime,
    setStartTime,
    setValidatedIndices,
    setUp,
    setupStatus,
    startTime,
    validatedIndices,
    validationErrors,
    viewResults
  };
};
exports.useLogEntryCategoriesSetup = useLogEntryCategoriesSetup;