"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAlertRuleButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateAlertRuleButton = ({
  onClick,
  ['data-test-subj']: dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": dataTestSubj,
    onClick: onClick,
    size: "xs",
    iconSide: "left",
    flush: "both",
    iconType: "bell"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.infra.alerts.createAlertLink",
    defaultMessage: "Create rule"
  }));
};
exports.CreateAlertRuleButton = CreateAlertRuleButton;