"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchMarker = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var React = _interopRequireWildcard(require("react"));
var _search_marker_tooltip = require("./search_marker_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SearchMarker extends React.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      hoveredPosition: null
    });
    (0, _defineProperty2.default)(this, "handleClick", evt => {
      evt.stopPropagation();
      this.props.jumpToTarget(this.props.bucket.representativeKey);
    });
    (0, _defineProperty2.default)(this, "handleMouseEnter", evt => {
      this.setState({
        hoveredPosition: evt.currentTarget.getBoundingClientRect()
      });
    });
    (0, _defineProperty2.default)(this, "handleMouseLeave", () => {
      this.setState({
        hoveredPosition: null
      });
    });
  }
  render() {
    const {
      bucket,
      height,
      width
    } = this.props;
    const {
      hoveredPosition
    } = this.state;
    const bulge = bucket.entriesCount > 1 ? /*#__PURE__*/React.createElement(SearchMarkerForegroundRect, {
      x: "-2",
      y: "-2",
      width: "4",
      height: height + 2,
      rx: "2",
      ry: "2"
    }) : /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SearchMarkerForegroundRect, {
      x: "-1",
      y: "0",
      width: "2",
      height: height
    }), /*#__PURE__*/React.createElement(SearchMarkerForegroundRect, {
      x: "-2",
      y: height / 2 - 2,
      width: "4",
      height: "4",
      rx: "2",
      ry: "2"
    }));
    return /*#__PURE__*/React.createElement(React.Fragment, null, hoveredPosition ? /*#__PURE__*/React.createElement(_search_marker_tooltip.SearchMarkerTooltip, {
      markerPosition: hoveredPosition
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.searchResultTooltip",
      defaultMessage: "{bucketCount, plural, one {# highlighted entry} other {# highlighted entries}}",
      values: {
        bucketCount: bucket.entriesCount
      }
    })) : null, /*#__PURE__*/React.createElement(SearchMarkerGroup, {
      onClick: this.handleClick,
      onMouseEnter: this.handleMouseEnter,
      onMouseLeave: this.handleMouseLeave
    }, /*#__PURE__*/React.createElement(SearchMarkerBackgroundRect, {
      x: "0",
      y: "0",
      width: width,
      height: height
    }), bulge));
  }
}
exports.SearchMarker = SearchMarker;
const fadeInAnimation = (0, _common.keyframes)`
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
`;
const SearchMarkerGroup = _common.euiStyled.g`
  animation: ${fadeInAnimation} ${props => props.theme.eui.euiAnimSpeedExtraSlow} ease-in both;
`;
const SearchMarkerBackgroundRect = _common.euiStyled.rect`
  fill: ${props => props.theme.eui.euiColorAccent};
  opacity: 0;
  transition: opacity ${props => props.theme.eui.euiAnimSpeedNormal} ease-in;
  cursor: pointer;

  ${SearchMarkerGroup}:hover & {
    opacity: 0.3;
  }
`;
const SearchMarkerForegroundRect = _common.euiStyled.rect`
  fill: ${props => props.theme.eui.euiColorAccent};
`;