"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryExampleMessagesEmptyIndicator = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryExampleMessagesEmptyIndicator = ({
  onReload
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  className: "eui-textNoWrap"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.logEntryExamples.exampleEmptyDescription",
  defaultMessage: "No examples found within the selected time range. Increase the log entry retention period to improve message sample availability."
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  "data-test-subj": "infraLogEntryExampleMessagesEmptyIndicatorReloadButton",
  onClick: onReload,
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.logs.logEntryExamples.exampleEmptyReloadButtonLabel",
  defaultMessage: "Reload"
}))));
exports.LogEntryExampleMessagesEmptyIndicator = LogEntryExampleMessagesEmptyIndicator;