"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalySeverityIndicator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _get_formatted_severity_score = require("@kbn/ml-anomaly-utils/get_formatted_severity_score");
var _log_analysis = require("../../../../common/log_analysis");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnomalySeverityIndicator = ({
  anomalyScore
}) => {
  const severityColor = (0, _react.useMemo)(() => getColorForAnomalyScore(anomalyScore), [anomalyScore]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: severityColor
  }, (0, _get_formatted_severity_score.getFormattedSeverityScore)(anomalyScore));
};
exports.AnomalySeverityIndicator = AnomalySeverityIndicator;
const getColorForAnomalyScore = anomalyScore => {
  const severityCategory = (0, _log_analysis.getSeverityCategoryForScore)(anomalyScore);
  if (severityCategory != null && severityCategory in _log_analysis.ML_SEVERITY_COLORS) {
    return _log_analysis.ML_SEVERITY_COLORS[severityCategory];
  } else {
    return 'subdued';
  }
};