"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _states = require("./states");
var _translations = require("../../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processSummaryNotAvailable = {
  total: _translations.NOT_AVAILABLE_LABEL,
  running: _translations.NOT_AVAILABLE_LABEL,
  sleeping: _translations.NOT_AVAILABLE_LABEL,
  dead: _translations.NOT_AVAILABLE_LABEL,
  stopped: _translations.NOT_AVAILABLE_LABEL,
  idle: _translations.NOT_AVAILABLE_LABEL,
  zombie: _translations.NOT_AVAILABLE_LABEL,
  unknown: _translations.NOT_AVAILABLE_LABEL
};
const SummaryTable = ({
  processSummary,
  isLoading
}) => {
  const mergedSummary = (0, _react.useMemo)(() => ({
    ...processSummaryNotAvailable,
    ...Object.fromEntries(Object.entries(processSummary).filter(([_, v]) => !!v))
  }), [processSummary]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    wrap: true
  }, Object.entries(mergedSummary).map(([field, value]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "infraAssetDetailsProcessesSummaryTableItem",
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    css: (0, _react2.css)`
                  white-space: nowrap;
                `
  }, columnTitles[field]), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }) : value))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }));
};
exports.SummaryTable = SummaryTable;
const columnTitles = {
  total: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.headingTotalProcesses', {
    defaultMessage: 'Total processes'
  }),
  ..._states.STATE_NAMES
};