"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToApmService = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkToApmService = ({
  serviceName,
  agentName,
  dateRange
}) => {
  const linkProps = (0, _public.useLinkProps)({
    app: 'apm',
    pathname: `/services/${serviceName}/overview`,
    search: {
      rangeFrom: dateRange.from,
      rangeTo: dateRange.to
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "serviceLink",
    color: "hollow",
    css: {
      padding: '4px'
    },
    href: linkProps.href,
    title: _i18n.i18n.translate('xpack.infra.assetDetails.services.serviceButtonTitle', {
      defaultMessage: '{serviceName} last reported by {agentName}',
      values: {
        serviceName,
        agentName
      }
    })
  }, agentName ? /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
    agentName: agentName,
    size: "m",
    css: {
      marginRight: '4px'
    },
    role: "presentation"
  }) : null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `serviceNameText-${serviceName}`
  }, serviceName)));
};
exports.LinkToApmService = LinkToApmService;