"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyAlertMetricCallout = exports.HOST_LEGACY_METRICS_DOC_HREF = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _snapshot_metric_i18n = require("../../../../../common/snapshot_metric_i18n");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
var _use_tab_switcher = require("../../hooks/use_tab_switcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_LEGACY_METRICS_DOC_HREF = exports.HOST_LEGACY_METRICS_DOC_HREF = 'https://ela.st/host-metrics-legacy';
const DISMISSAL_LEGACY_ALERT_METRIC_STORAGE_KEY = 'infraAssetDetails:legacy_alert_metric_dismissed';
const LegacyAlertMetricCallout = ({
  visibleFor,
  metric
}) => {
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const [isDismissed, setDismissed] = (0, _useLocalStorage.default)(`${DISMISSAL_LEGACY_ALERT_METRIC_STORAGE_KEY}_${metric}`, false);
  const onDismiss = () => {
    setDismissed(true);
  };
  const metricLabel = (0, _snapshot_metric_i18n.toMetricOpt)(metric, asset.id);
  const hideCallout = isDismissed || !visibleFor.includes(activeTabId);
  if (hideCallout || !metricLabel) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.assetDetails.callouts.legacyMetricAlertCallout.title",
      defaultMessage: "We have an updated definition for {metric}",
      values: {
        metric: metricLabel.text
      }
    }),
    "data-test-subj": "infraAssetDetailsLegacyMetricAlertCallout",
    onDismiss: onDismiss
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.callouts.legacyMetricAlertCallout",
    defaultMessage: "The alert you have clicked through is using the legacy {metric}. {learnMoreLink}",
    values: {
      metric: metricLabel.text,
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraAssetDetailsLegacyMetricAlertCalloutLink",
        href: HOST_LEGACY_METRICS_DOC_HREF,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.assetDetails.callouts.legacyMetricAlertCallout.learnMoreLinkLabel",
        defaultMessage: "Learn More"
      }))
    }
  }));
};
exports.LegacyAlertMetricCallout = LegacyAlertMetricCallout;