"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPromptApi = createPromptApi;
var _inferenceCommon = require("@kbn/inference-common");
var _callback_api = require("../chat_complete/callback_api");
var _prompt_to_message_options = require("../../common/prompt/prompt_to_message_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createPromptApi({
  request,
  actions,
  logger,
  anonymizationRulesPromise,
  regexWorker,
  esClient
}) {
  const callbackApi = (0, _callback_api.createChatCompleteCallbackApi)({
    request,
    actions,
    logger,
    anonymizationRulesPromise,
    regexWorker,
    esClient
  });
  return options => {
    const {
      connectorId,
      stream,
      abortSignal,
      prompt,
      input,
      prevMessages,
      retryConfiguration,
      maxRetries,
      ...rest
    } = options;
    return callbackApi({
      connectorId,
      stream,
      abortSignal,
      maxRetries,
      retryConfiguration
    }, executor => {
      var _rest$metadata;
      const connector = executor.getConnector();
      const family = (0, _inferenceCommon.getConnectorFamily)(connector);
      const provider = (0, _inferenceCommon.getConnectorProvider)(connector);
      const id = (0, _inferenceCommon.getConnectorModel)(connector);
      const {
        match,
        options: nextOptions
      } = (0, _prompt_to_message_options.promptToMessageOptions)(prompt, input, {
        family,
        provider,
        id
      });
      const template = 'mustache' in match.template ? match.template.mustache.template : undefined;
      return {
        ...rest,
        ...nextOptions,
        messages: nextOptions.messages.concat(prevMessages !== null && prevMessages !== void 0 ? prevMessages : []),
        metadata: {
          ...rest.metadata,
          attributes: {
            ...((_rest$metadata = rest.metadata) === null || _rest$metadata === void 0 ? void 0 : _rest$metadata.attributes),
            'gen_ai.prompt.id': prompt.name,
            'gen_ai.prompt.template.template': template,
            'gen_ai.prompt.template.variables': JSON.stringify(input)
          }
        }
      };
    });
  };
}