"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertUpstreamError = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const connectorStatusCodeRegexp = /Status code: ([0-9]{3})/i;
const inferenceStatusCodeRegexp = /status \[([0-9]{3})\]/i;
const convertUpstreamError = (source, {
  statusCode,
  messagePrefix
} = {}) => {
  const message = typeof source === 'string' ? source : source.message;
  let status = statusCode;
  if (!status && typeof source === 'object') {
    var _status, _response;
    status = (_status = source.status) !== null && _status !== void 0 ? _status : (_response = source.response) === null || _response === void 0 ? void 0 : _response.status;
  }
  if (!status) {
    const match = connectorStatusCodeRegexp.exec(message);
    if (match) {
      status = parseInt(match[1], 10);
    }
  }
  if (!status) {
    const match = inferenceStatusCodeRegexp.exec(message);
    if (match) {
      status = parseInt(match[1], 10);
    }
  }
  const messageWithPrefix = messagePrefix ? `${messagePrefix} ${message}` : message;
  return (0, _inferenceCommon.createInferenceProviderError)(messageWithPrefix, {
    status
  });
};
exports.convertUpstreamError = convertUpstreamError;