"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveTemplate = exports.getTemplateDataStreamOptions = exports.doesTemplateExist = void 0;
var _lib = require("../../../../common/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const doesTemplateExist = async ({
  name,
  client,
  isLegacy
}) => {
  if (isLegacy) {
    return await client.asCurrentUser.indices.existsTemplate({
      name
    });
  }
  return await client.asCurrentUser.indices.existsIndexTemplate({
    name
  });
};
exports.doesTemplateExist = doesTemplateExist;
const saveTemplate = async ({
  template,
  client,
  isLegacy,
  dataStreamOptions
}) => {
  const serializedTemplate = isLegacy ? (0, _lib.serializeLegacyTemplate)(template) : (0, _lib.serializeTemplate)(template, dataStreamOptions);
  if (isLegacy) {
    const {
      order,
      // eslint-disable-next-line @typescript-eslint/naming-convention
      index_patterns,
      version,
      settings,
      mappings,
      aliases
    } = serializedTemplate;
    return await client.asCurrentUser.indices.putTemplate({
      name: template.name,
      order,
      body: {
        index_patterns,
        version,
        // @ts-expect-error Types of property auto_expand_replicas are incompatible.
        settings,
        mappings,
        aliases
      }
    });
  }
  return await client.asCurrentUser.indices.putIndexTemplate({
    name: template.name,
    // @ts-expect-error LegacyTemplateSerialized | TemplateSerialized conflicts with @elastic/elasticsearch IndicesPutIndexTemplateRequest
    body: serializedTemplate
  });
};
exports.saveTemplate = saveTemplate;
const getTemplateDataStreamOptions = async ({
  name,
  client,
  isLegacy
}) => {
  var _existingTemplate$ind, _existingTemplate$ind2, _existingTemplate$ind3, _existingTemplate$ind4;
  if (isLegacy) {
    return undefined;
  }
  const existingTemplate = await client.asCurrentUser.transport.request({
    method: 'GET',
    path: `/_index_template/${name}`
  });
  // TODO: Replace with the following when the client includes data_stream_options in IndicesIndexTemplateSummary
  // https://github.com/elastic/kibana/issues/220614
  // const existingTemplate = await client.asCurrentUser.indices.getIndexTemplate({
  //   name,
  // });

  return existingTemplate === null || existingTemplate === void 0 ? void 0 : (_existingTemplate$ind = existingTemplate.index_templates) === null || _existingTemplate$ind === void 0 ? void 0 : (_existingTemplate$ind2 = _existingTemplate$ind[0]) === null || _existingTemplate$ind2 === void 0 ? void 0 : (_existingTemplate$ind3 = _existingTemplate$ind2.index_template) === null || _existingTemplate$ind3 === void 0 ? void 0 : (_existingTemplate$ind4 = _existingTemplate$ind3.template) === null || _existingTemplate$ind4 === void 0 ? void 0 : _existingTemplate$ind4.data_stream_options;
};
exports.getTemplateDataStreamOptions = getTemplateDataStreamOptions;