"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _reset_index_url_params = require("./reset_index_url_params");
var _constants = require("../../../../../../common/constants");
var _services = require("../../../../services");
var _details_page_error = require("./details_page_error");
var _details_page_content = require("./details_page_content");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsPage = ({
  location: {
    search
  },
  history
}) => {
  var _queryParams$get, _queryParams$get2;
  const queryParams = (0, _react.useMemo)(() => new URLSearchParams(search), [search]);
  const indexName = (_queryParams$get = queryParams.get('indexName')) !== null && _queryParams$get !== void 0 ? _queryParams$get : '';
  const tab = (_queryParams$get2 = queryParams.get('tab')) !== null && _queryParams$get2 !== void 0 ? _queryParams$get2 : _constants.IndexDetailsSection.Overview;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(null);
  const [index, setIndex] = (0, _react.useState)();
  const navigateToIndicesList = (0, _react.useCallback)(() => {
    const paramsString = (0, _reset_index_url_params.resetIndexUrlParams)(search);
    history.push(`/${_constants.Section.Indices}${paramsString ? '?' : ''}${paramsString}`);
  }, [history, search]);
  const fetchIndexDetails = (0, _react.useCallback)(async () => {
    if (indexName) {
      setIsLoading(true);
      try {
        const {
          data,
          error: loadingError
        } = await (0, _services.loadIndex)(indexName);
        setIsLoading(false);
        setError(loadingError);
        setIndex(data);
      } catch (e) {
        setIsLoading(false);
        setError(e);
      }
    }
  }, [indexName]);
  (0, _react.useEffect)(() => {
    fetchIndexDetails();
  }, [fetchIndexDetails]);
  if (!indexName) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      "data-test-subj": "indexDetailsNoIndexNameError",
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.noIndexNameErrorTitle",
        defaultMessage: "Unable to load index details"
      })),
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexDetails.noIndexNameErrorDescription",
        defaultMessage: "An index name is required for this page. Add a query parameter {queryParam} followed by an index name to the url.",
        values: {
          queryParam: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "indexName")
        }
      }))
    });
  }
  if (isLoading && !index) {
    return /*#__PURE__*/_react.default.createElement(_public.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.indexDetails.loadingDescription",
      defaultMessage: "Loading index details\u2026"
    }));
  }
  if (error || !index) {
    return /*#__PURE__*/_react.default.createElement(_details_page_error.DetailsPageError, {
      indexName: indexName,
      resendRequest: fetchIndexDetails,
      navigateToIndicesList: navigateToIndicesList
    });
  }
  return /*#__PURE__*/_react.default.createElement(_details_page_content.DetailsPageContent, {
    index: index,
    tab: tab,
    fetchIndexDetails: fetchIndexDetails,
    history: history,
    search: search,
    navigateToIndicesList: navigateToIndicesList
  });
};
exports.DetailsPage = DetailsPage;