"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.homeSections = exports.IndexManagementHome = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _documentation = require("../../services/documentation");
var _component_templates = require("../../components/component_templates");
var _app_context = require("../../app_context");
var _index_list = require("./index_list");
var _enrich_policies_list = require("./enrich_policies_list");
var _details_page = require("./index_list/details_page");
var _data_stream_list = require("./data_stream_list");
var _template_list = require("./template_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const homeSections = exports.homeSections = [_constants.Section.Indices, _constants.Section.DataStreams, _constants.Section.IndexTemplates, _constants.Section.ComponentTemplates, _constants.Section.EnrichPolicies];
const IndexManagementHome = ({
  match: {
    params: {
      section
    }
  },
  history
}) => {
  const {
    plugins: {
      console: consolePlugin
    },
    privs
  } = (0, _app_context.useAppContext)();
  const tabs = [{
    id: _constants.Section.Indices,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.indicesTabTitle",
      defaultMessage: "Indices"
    })
  }, {
    id: _constants.Section.DataStreams,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.dataStreamsTabTitle",
      defaultMessage: "Data Streams"
    })
  }, {
    id: _constants.Section.IndexTemplates,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.indexTemplatesTabTitle",
      defaultMessage: "Index Templates"
    })
  }];
  if (privs.manageIndexTemplates) {
    tabs.push({
      id: _constants.Section.ComponentTemplates,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.componentTemplatesTabTitle",
        defaultMessage: "Component Templates"
      })
    });
  }
  if (privs.monitorEnrich) {
    tabs.push({
      id: _constants.Section.EnrichPolicies,
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.home.enrichPoliciesTabTitle",
        defaultMessage: "Enrich Policies"
      })
    });
  }
  const onSectionChange = newSection => {
    history.push(`/${newSection}`);
  };
  const indexManagementTabs = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": "indexManagementHeaderContent",
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "appTitle"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.appTitle",
      defaultMessage: "Index Management"
    })),
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: _documentation.documentationService.getIdxMgmtDocumentationLink(),
      target: "_blank",
      iconType: "question",
      "data-test-subj": "documentationLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.home.idxMgmtDocsLinkText",
      defaultMessage: "Index Management docs"
    }))],
    tabs: tabs.map(tab => ({
      onClick: () => onSectionChange(tab.id),
      isSelected: tab.id === section,
      key: tab.id,
      'data-test-subj': `${tab.id}Tab`,
      label: tab.name
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${_constants.Section.DataStreams}`, `/${_constants.Section.DataStreams}/:dataStreamName?`],
    component: _data_stream_list.DataStreamList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/${_constants.Section.Indices}`,
    component: _index_list.IndexList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${_constants.Section.IndexTemplates}`, `/${_constants.Section.IndexTemplates}/:templateName?`],
    component: _template_list.TemplateList
  }), privs.manageIndexTemplates && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [`/${_constants.Section.ComponentTemplates}`, `/${_constants.Section.ComponentTemplates}/:componentTemplateName?`],
    component: _component_templates.ComponentTemplateList
  }), privs.monitorEnrich && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/${_constants.Section.EnrichPolicies}`,
    component: _enrich_policies_list.EnrichPoliciesList
  })), consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, null) : null);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/${_constants.Section.Indices}/index_details`,
    component: _details_page.IndexDetailsPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => indexManagementTabs
  }));
};
exports.IndexManagementHome = IndexManagementHome;