"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _create_policy_context = require("../create_policy_context");
var _lib = require("../../../../../common/lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Beyond a certain point, highlighting the syntax will bog down performance to unacceptable
// levels. This way we prevent that happening for very large requests.
const getLanguageForQuery = query => query.length < 60000 ? 'json' : undefined;
const SummaryTab = ({
  policy
}) => {
  const queryAsString = policy.query ? JSON.stringify(policy.query, null, 2) : '';
  const language = getLanguageForQuery(queryAsString);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "enrichPolicySummaryList"
  }, policy.name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.nameLabel', {
    defaultMessage: 'Name'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyNameValue"
  }, policy.name)), policy.type && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.typeLabel', {
    defaultMessage: 'Type'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyTypeValue"
  }, policy.type)), policy.sourceIndices && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.sourceIndicesLabel', {
    defaultMessage: 'Source indices'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyIndicesValue"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ul", null, policy.sourceIndices.map(index => /*#__PURE__*/_react.default.createElement("li", {
    key: index,
    className: "eui-textBreakWord"
  }, index)))))), policy.matchField && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.matchFieldLabel', {
    defaultMessage: 'Match field'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyMatchFieldValue"
  }, policy.matchField)), policy.enrichFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.enrichFieldsLabel', {
    defaultMessage: 'Enrich fields'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyEnrichFieldsValue"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ul", null, policy.enrichFields.map(field => /*#__PURE__*/_react.default.createElement("li", {
    key: field,
    className: "eui-textBreakWord"
  }, field)))))), policy.query && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.queryLabel', {
    defaultMessage: 'Query'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: language,
    isCopyable: true
  }, queryAsString)))));
};
const RequestTab = ({
  policy
}) => {
  const request = JSON.stringify((0, _lib.serializeAsESPolicy)(policy), null, 2);
  const language = getLanguageForQuery(request);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.createStep.descriptionText",
    defaultMessage: "This request will create the following enrich policy."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: language,
    isCopyable: true,
    "data-test-subj": "requestBody"
  }, (0, _lib.getESPolicyCreationApiCall)(policy.name), `\n`, request));
};
const CREATE_AND_EXECUTE_POLICY = true;
const CreateStep = ({
  onBack,
  onSubmit,
  isLoading
}) => {
  const {
    draft
  } = (0, _create_policy_context.useCreatePolicyContext)();
  const summaryTabs = [{
    id: 'summary',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.summaryTabLabel', {
      defaultMessage: 'Summary'
    }),
    'data-test-subj': 'summaryTab',
    content: /*#__PURE__*/_react.default.createElement(SummaryTab, {
      policy: draft
    })
  }, {
    id: 'request',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.requestTabLabel', {
      defaultMessage: 'Request'
    }),
    'data-test-subj': 'requestTab',
    content: /*#__PURE__*/_react.default.createElement(RequestTab, {
      policy: draft
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: summaryTabs
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "creationStep",
    justifyContent: "spaceBetween",
    style: {
      maxWidth: 400
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    minWidth: false,
    color: "primary",
    iconSide: "left",
    iconType: "arrowLeft",
    "data-test-subj": "backButton",
    onClick: onBack
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.createStep.backButtonLabel",
    defaultMessage: "Back"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: () => onSubmit(),
    isDisabled: isLoading,
    "data-test-subj": "createButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.createStep.createButtonLabel",
    defaultMessage: "Create"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: () => onSubmit(CREATE_AND_EXECUTE_POLICY),
    isDisabled: isLoading,
    "data-test-subj": "createAndExecuteButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.createStep.createAndExecuteButtonLabel",
    defaultMessage: "Create and execute"
  }))))));
};
exports.CreateStep = CreateStep;