"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoMatch = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _create_index_button = require("../../sections/home/index_list/create_index/create_index_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoMatch = ({
  loadIndices,
  filter,
  resetFilter,
  extensionsService,
  share
}) => {
  if (filter) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "noIndicesMessage",
      title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.noMatch.noIndicesTitle",
        defaultMessage: "No indices found"
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.noMatch.noIndicesDescription",
        defaultMessage: "Start a new search or try using different filters."
      })),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: resetFilter,
        fill: true,
        color: "primary",
        iconType: "cross",
        "data-test-subj": "clearIndicesSearch"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.noMatch.clearSearchButton",
        defaultMessage: "Clear search"
      }))
    });
  }
  if (extensionsService.emptyListContent) {
    return extensionsService.emptyListContent.renderContent({
      createIndexButton: /*#__PURE__*/_react.default.createElement(_create_index_button.CreateIndexButton, {
        loadIndices: loadIndices,
        share: share,
        dataTestSubj: "createIndexButtonEmptyList"
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "createIndexMessage",
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.noMatch.createIndexTitle",
      defaultMessage: "No indices"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.noMatch.createIndexDescription",
      defaultMessage: "You don't have any indices yet."
    })),
    actions: /*#__PURE__*/_react.default.createElement(_create_index_button.CreateIndexButton, {
      loadIndices: loadIndices,
      share: share,
      dataTestSubj: "createIndexButtonEmptyList"
    })
  });
};
exports.NoMatch = NoMatch;