"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_DEPTH_DEFAULT_EDITOR = exports.LEFT_PADDING_SIZE_FIELD_ITEM_WRAPPER = exports.EUI_SIZE = exports.CHILD_FIELD_INDENT_SIZE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The max nested depth allowed for child fields.
 * Above this thresold, the user has to use the JSON editor.
 */
const MAX_DEPTH_DEFAULT_EDITOR = exports.MAX_DEPTH_DEFAULT_EDITOR = 4;

/**
 * 16px is the default $euiSize Sass variable.
 * @link https://elastic.github.io/eui/#/guidelines/sass
 */
const EUI_SIZE = exports.EUI_SIZE = 16;
const CHILD_FIELD_INDENT_SIZE = exports.CHILD_FIELD_INDENT_SIZE = EUI_SIZE * 1.5;
const LEFT_PADDING_SIZE_FIELD_ITEM_WRAPPER = exports.LEFT_PADDING_SIZE_FIELD_ITEM_WRAPPER = EUI_SIZE * 0.25;