"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppWithoutRouter = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _home = require("./sections/home");
var _template_create = require("./sections/template_create");
var _template_clone = require("./sections/template_clone");
var _template_edit = require("./sections/template_edit");
var _enrich_policy_create = require("./sections/enrich_policy_create");
var _app_context = require("./app_context");
var _components = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = ({
  history
}) => {
  const {
    services
  } = (0, _app_context.useAppContext)();
  (0, _react.useEffect)(() => services.uiMetricService.trackMetric(_analytics.METRIC_TYPE.LOADED, _constants.UIM_APP_LOAD), [services.uiMetricService]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(AppWithoutRouter, null));
};

// Export this so we can test it with a different router.
exports.App = App;
const AppWithoutRouter = () => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_template",
  component: _template_create.TemplateCreate
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/clone_template/:name*",
  component: _template_clone.TemplateClone
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/edit_template/:name*",
  component: _template_edit.TemplateEdit
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_component_template",
  component: _components.ComponentTemplateCreate
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_component_template/:sourceComponentTemplateName",
  component: _components.ComponentTemplateClone
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/edit_component_template/:name*",
  component: _components.ComponentTemplateEdit
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/enrich_policies/create",
  component: _enrich_policy_create.EnrichPolicyCreate
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/:section(${_home.homeSections.join('|')})`,
  component: _home.IndexManagementHome
}), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  from: `/`,
  to: `/${_constants.Section.Indices}`
}));
exports.AppWithoutRouter = AppWithoutRouter;