"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PhaseIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("./phase_icon.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PhaseIcon = ({
  enabled,
  phase
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `ilmPhaseIcon ilmPhaseIcon--${phase} ${enabled ? '' : 'ilmPhaseIcon--disabled'}`
  }, enabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: `ilmPhaseIcon__inner--${phase}`,
    type: phase === 'delete' ? 'trash' : 'checkInCircleFilled',
    size: phase === 'delete' ? 'm' : 'l'
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: "ilmPhaseIcon__inner--disabled",
    type: 'dot',
    size: 's'
  }));
};
exports.PhaseIcon = PhaseIcon;