"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidePanelFlyoutFooter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const GuidePanelFlyoutFooter = ({
  styles,
  euiTheme,
  openQuitGuideModal
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.flyoutOverrides.flyoutFooter
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "xs",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "question",
    iconSide: "right",
    href: "https://cloud.elastic.co/support ",
    target: "_blank",
    css: styles.flyoutOverrides.flyoutFooterLink,
    iconSize: "m"
  }, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.footer.support', {
    defaultMessage: 'Need help?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: euiTheme.colors.disabled
  }, "|")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "faceHappy",
    iconSide: "right",
    href: "https://www.elastic.co/kibana/feedback",
    target: "_blank",
    css: styles.flyoutOverrides.flyoutFooterLink,
    iconSize: "s"
  }, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.footer.feedback', {
    defaultMessage: 'Give feedback'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: euiTheme.colors.disabled
  }, "|")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "exit",
    iconSide: "right",
    onClick: openQuitGuideModal,
    "data-test-subj": "quitGuideButton",
    css: styles.flyoutOverrides.flyoutFooterLink,
    iconSize: "s"
  }, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.footer.exitGuideButtonLabel', {
    defaultMessage: 'Quit guide'
  })))));
};
exports.GuidePanelFlyoutFooter = GuidePanelFlyoutFooter;